package com.zjty.fp.api.vomp.subject.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.zjty.fp.api.misc.entity.UnionEvent;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.Date;

/**
 * <p>Description : fp-api
 * <p>Date : 2018/11/8 16:04
 * <p>@author : C
 */
@SuppressWarnings("unused")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class VompEvent extends UnionEvent {
    /**
     * 序号
     */
    @Excel(name = "序号", orderNum = "1", width = 20)
    @ApiModelProperty(value = "序号", example = "128")
    private Integer recno;

    /**
     * 处理单号
     */
    @Excel(name = "处理单号", orderNum = "2")
    @ApiModelProperty(value = "处理单号", example = "123")
    private String statId;

    /**
     * 单位名
     */
    @Excel(name = "单位名", orderNum = "4")
    @ApiModelProperty(value = "单位名", example = "杭州市局测试")
    private String unitName;

    /**
     * 部门名
     */
    @Excel(name = "部门名", orderNum = "5")
    @ApiModelProperty(value = "部门名", example = "公诉⼆科")
    private String deptment;

    /**
     * 负责人
     */
    @Excel(name = "负责人", orderNum = "6")
    @ApiModelProperty(value = "负责人", example = "张三")
    private String tUser;

    /**
     * 主机名
     */
    @Excel(name = "主机名", orderNum = "7")
    @ApiModelProperty(value = "主机名", example = "pgos")
    private String hostName;

    /**
     * 转发
     */
    @Excel(name = "转发", orderNum = "8")
    @ApiModelProperty(value = "转发", example = "SZJC")
    private String tReserve;

    /**
     * 操作系统
     */
    @Excel(name = "操作系统", orderNum = "9")
    @ApiModelProperty(value = "操作系统", example = "Win7")
    private String tos;

    /**
     * 网卡信息
     */
    @Excel(name = "网卡信息", orderNum = "10", width = 20)
    @ApiModelProperty(value = "网卡信息", example = "[Marvell Yukon 88E8057 PCI-E Gigabit Ethernet Controller -数据包计划程序微型端口]")
    private String tCard;

    /**
     * mac地址
     */
    @Excel(name = "mac地址", orderNum = "11", width = 20)
    @ApiModelProperty(value = "mac地址", example = "F5 15 85 E6 37 44")
    private String macStr;

    /**
     * 内网ip
     */
    @Excel(name = "内网ip", orderNum = "12", width = 16)
    @ApiModelProperty(value = "内网ip", example = "192.168.1.1")
    private String ipStr;

    /**
     * 外网ip
     */
    @Excel(name = "外网ip", orderNum = "13", width = 16)
    @ApiModelProperty(value = "序号", example = "20.1.1.1")
    private String outIpstr;

    /**
     * 主板序列号
     */
    @Excel(name = "主板序列号", orderNum = "14", width = 20, height = 20)
    @ApiModelProperty(value = "主板序列号", example = "LENOVO To be filled by O.E.M SN:INVALID")
    private String masterCode;

    /**
     * 硬盘序列号
     */
    @Excel(name = "硬盘序列号", orderNum = "15")
    @ApiModelProperty(value = "硬盘序列号", example = "123456HD")
    private String hdCode;

    /**
     * 外联描述
     */
    @Excel(name = "外联描述", orderNum = "16", width = 26, height = 20)
    @ApiModelProperty(value = "外联描述", example = "经由⽹关[183.129.165.83]违规外联")
    private String tMemo;

    /**
     * 状态
     */
    @Excel(name = "状态", orderNum = "17")
    @ApiModelProperty(value = "状态", example = "未读")
    private String statStatus;

    /**
     * 地区名
     */
    @Excel(name = "地区名", orderNum = "18")
    @ApiModelProperty(value = "地区名", example = "浙江省杭州市西湖区")
    private String zoneName;

    public VompEvent(String platform, Date tmFetch, Integer recno, String statId, String unitName, String deptment, String tUser, String hostName, String tReserve, String tos, String tCard, String macStr, String ipStr, String outIpstr, String masterCode, String hdCode, String tMemo, String statStatus, String zoneName) {
        super(platform, tmFetch);
        this.recno = recno;
        this.statId = statId;
        this.unitName = unitName;
        this.deptment = deptment;
        this.tUser = tUser;
        this.hostName = hostName;
        this.tReserve = tReserve;
        this.tos = tos;
        this.tCard = tCard;
        this.macStr = macStr;
        this.ipStr = ipStr;
        this.outIpstr = outIpstr;
        this.masterCode = masterCode;
        this.hdCode = hdCode;
        this.tMemo = tMemo;
        this.statStatus = statStatus;
        this.zoneName = zoneName;
    }

    public String gettUser() {
        return tUser;
    }

    public String gettReserve() {
        return tReserve;
    }

    public String gettCard() {
        return tCard;
    }

    public String gettMemo() {
        return tMemo;
    }

}
