package com.zjty.fp.api.vomp.subject.service.api;

import com.zjty.fp.api.vomp.subject.entity.localdo.*;
import com.zjty.fp.api.vomp.subject.entity.remotedo.*;
import com.zjty.fp.api.vomp.subject.entity.vo.VompEvent;
import com.zjty.fp.api.vomp.subject.service.cache.VompTransCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/12/28 15:05
 * <p>@author : C
 * 数据转换工具bean
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Component
public class VompTransHelper {
    @Autowired
    VompTransCache transCache;

    /**
     * VompAlarm -> VompEvent
     */
    public VompEvent transToVompEvent(VompAlarm alarm) {
        return new VompEvent(
                "vomp",
                alarm.getOutBegin(),
                alarm.getRecno(),
                alarm.getStatId(),
                alarm.getUnitName(),
                alarm.getDeptment(),
                alarm.getTUser(),
                alarm.getHostName(),
                alarm.getTReserve(),
                alarm.getTos(),
                alarm.getTCard(),
                alarm.getMacStr(),
                alarm.getIpStr(),
                alarm.getOutIpstr(),
                alarm.getMasterCode(),
                alarm.getHdCode(),
                alarm.getTMemo(),
                alarm.getStatStatus(),
                transCache.getZoneId_ZoneName_Map().get(alarm.getZoneCode())
        );
    }

    /**
     * String -> Integer
     * 如果是空则替换为0
     *
     * @param number input
     * @return output
     */
    private Integer transToInteger(String number) {
        if (number == null || "".equals(number)) {
            return 0;
        } else {
            return Integer.valueOf(number);
        }
    }

    /**
     * String -> Double
     * 如果是空则替换为0
     *
     * @param number input
     * @return output
     */
    private Double transToDouble(String number) {
        if (number == null || "".equals(number)) {
            return 0.0;
        } else {
            return Double.valueOf(number);
        }
    }

    /**
     * @param zone      Zone对象
     * @param pcloglist 该Zone对象关联的所有Pclog
     * @return VompPcinfo对象
     */
    public VompPcInfo transToVompPcInfoVo(Zone zone, List<PcLog> pcloglist) {
        String alarmCount = String.valueOf(pcloglist.size());
        String zonePcCount = zone.getZonePcCount();
        Integer zonePcCountInt;
        String alarmRate;
        if (zonePcCount != null) {
            zonePcCountInt = Integer.valueOf(zonePcCount);
            alarmRate = new DecimalFormat("0.00").format(pcloglist.size() / zonePcCountInt);
        } else {
            alarmRate = null;
        }
        return new VompPcInfo(
                zone.getZoneId(),
                zone.getZoneName(),
                zone.getZonePcCount(),
                zone.getZonePaCount(),
                getInstallRate(zone),
                alarmCount,
                alarmRate,
                zone.getZoneOperator(),
                zone.getZoneStamp()
        );
    }

    private String getInstallRate(Zone zone) {
        DecimalFormat df = new DecimalFormat("#.00");
        Double result = transToDouble(zone.getZonePcCount()) / transToDouble(zone.getZonePaCount());
        Double zero = 0.;
        if (transToDouble(zone.getZonePaCount()).equals(zero)) {
            return "-1";
        } else {
            return df.format(result);
        }
    }

    /**
     * @param chkstates ChkStates对象
     * @param pclog     关联Pclog对象
     * @return VompAlarm对象
     */
    public VompAlarm transToVompAlarm(ChkStates chkstates, PcLog pclog) {
        return new VompAlarm(
                pclog.getRecno(),
                chkstates.getStatId().toString(),
                pclog.getOutbegin(),
                pclog.getUnitName(),
                pclog.getDeptment(),
                pclog.getTUser(),
                pclog.getHostname(),
                pclog.getTReserve(),
                pclog.getTos(),
                pclog.getTCard(),
                pclog.getMacStr(),
                pclog.getIpStr(),
                pclog.getOutIpstr(),
                pclog.getMasterCode(),
                pclog.getHdCode(),
                pclog.getTver(),
                pclog.getTmemo(),
                pclog.getTCompany(),
                transCache.getStatusMap().get(chkstates.getStatStatus()),
                pclog.getZoneCode(),
                pclog.getUnitCode()
        );
    }

    /**
     * @param chkstates ChkStates对象
     * @param chkroutes ChkRoutes对象
     * @return VompHandingInfo
     */
    public VompHandingInfo transToHandingInfo(ChkStates chkstates, ChkRoutes chkroutes) {
        return new VompHandingInfo(
                chkstates.getStatId(),
                chkroutes.getRoutInspector(),
                chkroutes.getRoutInspectorX(),
                chkroutes.getRoutOperator(),
                chkroutes.getRoutStatus(),
                chkroutes.getRoutStamp()
        );
    }

    /**
     * ServerStatus -> VompStatus
     *
     * @param serverStatus ServerStatus对象
     * @return VompStatus对象
     */
    public VompStatus transToStatus(ServerStatus serverStatus) {
        return new VompStatus(
                serverStatus.getServerStatusId(),
                serverStatus.getHName(),
                serverStatus.getContact(),
                serverStatus.getPhone(),
                serverStatus.getLTime(),
                serverStatus.getUri(),
                serverStatus.getUTime(),
                serverStatus.getTZone(),
                serverStatus.getAds(),
                serverStatus.getNip(),
                serverStatus.getProp()
        );
    }

    /**
     * Zone -> VompZone
     */
    public VompZone transToVompZone(Zone zone) {
        return new VompZone(
                zone.getZoneId(),
                zone.getZoneName(),
                zone.getParentID(),
                zone.getXOrigin(),
                zone.getYOrigin()
        );
    }

    /**
     * 地区名加上父地区名
     * 例如：杭州市->浙江省杭州市
     */
    public VompZone addParentZoneName(VompZone vompZone) {
        Optional<Zone> parentZoneOP = transCache.getZoneList().stream()
                .filter(zone -> zone.getZoneId().equals(vompZone.getParentId()))
                .findAny();
        if (parentZoneOP.isPresent()) {
            String parentZoneName = parentZoneOP.get().getZoneName();
            vompZone.setZoneName(parentZoneName + vompZone.getZoneName());
        }
        return vompZone;
    }

    /**
     * 加上祖父地区名
     * 例如：杭州市->浙江省杭州市->中国浙江省杭州市
     */
    public VompZone addGrandParentZoneName(VompZone vompZone) {
        Optional<Zone> grandParentZoneOP = transCache.getZoneList().stream()
                .filter(zone -> zone.getZoneId().equals(transCache.getZoneId_ParentZoneId_Map().get(vompZone.getParentId())))
                .findAny();
        if (grandParentZoneOP.isPresent()) {
            String grandParentZoneName = grandParentZoneOP.get().getZoneName();
            vompZone.setZoneName(grandParentZoneName + vompZone.getZoneName());
        }
        return vompZone;
    }

    /**
     * 以Integer类型输出该地区的监控终端数量
     *
     * @return Integer
     */
    public Integer getPcCount(VompPcInfo pcInfo) {
        return transToInteger(pcInfo.getZonePcCount());
    }
}
