package com.zjty.fp.api.vomp.subject.service.api.impl;

import com.zjty.fp.api.misc.entity.UnionEvent;
import com.zjty.fp.api.vomp.subject.entity.vo.VompEvent;
import com.zjty.fp.api.vomp.subject.repository.local.VompAlarmRepository;
import com.zjty.fp.api.vomp.subject.service.api.VompEventService;
import com.zjty.fp.api.vomp.subject.service.api.VompJudgeHelper;
import com.zjty.fp.api.vomp.subject.service.api.VompTransHelper;
import com.zjty.fp.api.vomp.subject.service.cache.VompTransCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import static java.util.Comparator.comparingLong;

/**
 * <p>Description : fp-fp
 * <p>Date : 2018/11/8 16:42
 * <p>@author : C
 * 对前端的告警事件页面提供API：根据页数查询、根据一组id查询、数据总数、今日数据总数。
 * 返回数据类型:
 *
 * @see UnionEvent
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Slf4j
@Service
public class VompEventServiceImpl implements VompEventService {
    @Autowired
    VompAlarmRepository vompAlarmRepository;
    @Autowired
    VompTransCache transCache;
    @Autowired
    VompTransHelper transHelper;
    @Autowired
    VompJudgeHelper judgeHelper;

    @Override
    public List<UnionEvent> findByPage(int page, int size) {
        List<UnionEvent> events = vompAlarmRepository.findAll(new PageRequest(page, size))
                .getContent().stream()
                .filter(judgeHelper::logicalExisted)
                .sorted(comparingLong(alarm -> alarm.getOutBegin().getTime()))
                .map(transHelper::transToVompEvent)
                .collect(Collectors.toList());
        Collections.reverse(events);
        return events;
    }

    @Override
    public List<UnionEvent> findByIds(List<Integer> ids) {
        return vompAlarmRepository.findAll(ids).stream()
                .filter(judgeHelper::logicalExisted)
                .map(transHelper::transToVompEvent)
                .collect(Collectors.toList());
    }

    @Override
    public List<VompEvent> findAllSubEvents(List<Integer> ids) {
        return vompAlarmRepository.findAll(ids).stream()
                .filter(judgeHelper::logicalExisted)
                .map(transHelper::transToVompEvent)
                .collect(Collectors.toList());
    }

    @Override
    public int totalCount() {
        return new Long(vompAlarmRepository.count()).intValue();
    }

    @Override
    public int dailyCount() {
        return new Long(vompAlarmRepository.findAll().stream()
                .filter(judgeHelper::logicalExisted)
                .filter(judgeHelper::isInToday)
                .count())
                .intValue();
    }

}
