前端接口文档
## 首页数据

### 概览

| 平台名             | URL                |
| --------------- | ------------------ |
| 首页报警数据接口        | `/fp/index/alarms` |
| 入网保密平台(nsrs)    | `/fp/index/nsrs`   |
| 违规外联（vomp)      | `/fp/index/vomp`   |
| 网络数据库平台(ndss)   | `/fp/index/ndss`   |
| 特种木马监测(stms)    | `/fp/index/stms`   |
| 互联网门户监管平台(pssp) | `/fp/index/pssp`   |

### 首页报警数据接口

```tex
接口地址 GET: /fp/index/alarms
application/json;charset=UTF-8
```

```json
{
    "total": "总报警数",
    "pssp" : "互联网门户平台的报警数",
    "nsrs" : "入网审查保密平台的报警数",
    "ndss" : "数据库检查端平台的报警数",
    "stms" : "特种木马监测平台的报警数",
    "vomp": "违规外联平台的报警数"
}
```

```json
{
    "total" : 10086,
    "pssp" : 10000,
    "nsrs" : 80,
    "ndss" : 1,
    "stms" : 5,
    "vomp": 0
}
```

### 入网保密平台(NSRS)

- 频率 10min/次

```tex
接口地址 GET: /fp/index/nsrs
application/json;charset=UTF-8
```

```json
{
    "netClient": {
        "netClientCount": "总终端数量",       
        "onlineNetClientCount": "当前在线终端数量" 
    },
    "department": {
        "departCount": "审查部门总数"       
    },
    "violation": {
        "violationCount": "总违规告警数量",    
        "todayViolationCount": "今日告警数量",
        "repairedCount": "今日已修复告警数量",     
        "repairedPercentage": "0%",  
        "notRepairedCount": "今日未修复告警数量",  
        "notRepairedPercentage": "0%"
    }
}
```

```json
{
    "netClient": {
        "netClientCount": 2,      
        "onlineNetClientCount": 1  
    },
    "department": {
        "departCount": 1          
    },
    "violation": {
        "violationCount": 2,      
        "todayViolationCount": 0, 
        "repairedCount": 0,        
        "repairedPercentage": "0%",  
        "notRepairedCount": 0,    
        "notRepairedPercentage": "0%"
    }
}
```

### 违规外联（VOMP)

- 频率: 60min/次

```tex
接口地址 GET: /fp/index/vomp
application/json;charset=UTF-8
```

```json
{
    "pcCount":"监控终端数量",                 
    "alarmCount":"总报警数",                
    "alarmRate":"总报警率"
}
```

```json
{
    "pcCount":80,                   
    "alarmCount":20,                
    "alarmRate":"0.25"
}
```

### 网络数据库平台(NDSS)

- 频率 : 1h/次

```tex
接口地址 GET: /fp/index/ndss
application/json;charset=UTF-8
```

```json
{
    "systemName":"系统名称",	    
    "size":"数据量",			   
    "ScanCount":"扫描条数",     
    "alarmCount":"涉密事件"       
}
```

```json
{
    "systemName":"OA",	     
    "size":4,			   
    "ScanCount":123456,     
    "alarmCount":1234        
}
```

- 主页面数据库检查平台的分析数据检查时间接口

- 频率 : 1h/次

```tex
接口地址 GET: /fp/index_time/ndss
application/json;charset=UTF-8
```

```json
{
    "time":"告警事件最早生成时间"	
}
```

```json
{
    "time":"2018-09-02 19:22:12"	
}
```

### 特种木马监测(STMS)

- 频率：15s/次

```tex
接口地址 GET: /fp/index/stms
application/json;charset=UTF-8
```

- 累计恶意和今日恶意行为数量

```json
{
    "sumCount":"累计恶意行为数量",       
    "timeSumCount":"今日恶意行为数量",	   
    "list":[
        {
            "type":"恶意行为类型",   
            "count":"恶意行为数量"      
        }
    ]
}
```

```json
{
    "sumCount":9,             
    "timeSumCount":0,	      
    "list":[
        {
            "type":"黑域名",  
            "count":2       
        }
    ]
}
```

### 互联网门户监管平台(PSSP)

- 频率 : 1min/次

```tex
接口地址 GET: /fp/index/pssp
application/json;charset=UTF-8
```

```json
{
    "cumulative" : "累计告警总数",      
    "today" : {
        "count" : "今日告警数量",			 
        "images" : "图片数量",        
        "webs" : "网页数量",          
        "archives" : "压缩包数量",         
        "docs" : "文档数量",		
        "red" : "红色报警数量",			
        "yellow" : "黄色报警数量",		
        "suspect" : "疑似报警数量"		
    }
}
```

```json
{
    "cumulative" : 40005942,     
    "today" : {
        "count" : 500,			
        "images" : 25,          
        "webs" : 30,            
        "archives" : 25,        
        "docs" : 20,			
        "red" : 40.4,			
        "yellow" : 20.1,		 
        "suspect" : 10			
    }
}
```



## 报警页面

### 概览

**数据格式**

```json
{
    "totalCount" : "查询总条数",
    "totalPage" : "总页数",
    "pageSize" : "每页显示条数",
    "CurrentPage" : "当前页数",
    "data" : {
        //
    }
}
```

**api**

- `/fp/union/events`

```json
{
    "totalCount" : 100,
    "totalPage" : 10,
    "pageSize" : 10,
    "currentPage" : 1,
    "data" : {
        //该data类型根据平台类型在下面列出
    }
}
```

### 互联网门户监管平台(PSSP)

```json
{
    "platform" : "平台名",
    "primaryId" : "分布式主键id",
    "id": "源系统id",
    "codeOrg": "所属地区的code，取值为四位整数",
    "idWebCategory":"网站入口分类，取值为 4:政府  5：高校  6：军工 7：金融  8：其他",
    "idWeb":"网站入口数据的ID",
    "matchKeyword":"所匹配到的关键字",
    "title":"数据的标题",
    "abs":"数据摘要",
    "webUrl":"源网页地址",
    "webSnapshot":"本地预览（快照）地址",
    "docUrl":"源附件地址",
    "docSnapshot":"附件预览（快照）地址",
    "tmFetch":"数据抓取时间",
    "handlerUser":"处理人，取值为 1：杭州市管理员，10：市直",
    "einZip":"数据是否为压缩包类型，0：否  1：是",
    "eident":"数据是否已读，0：未读，1：已读",
    "ealert":"告警等级，3：红  2：黄  1：绿",
    "etype":"数据类型，  0：未知  1：网页  2:图片  3：文档  4：压缩包 5：多媒体",
    "estatus":"处理状态， 0：未处理  10：正常  20：疑似  30：泄密"
}
```

```json
{
    "platform" : "平台名",
    "primaryId": 256828415544393728,
    "id": 1,
    "codeOrg": 1010,
    "idWebCategory": 4,
    "idWeb": 2355,
    "matchKeyword": "",
    "title": "淳安：市法制办为山区群众送上增收“钥匙”",
    "abs": "149 党政动态 /col/col811162/index.html 区县之窗 /col/col812257/index.html 县市 /col/col812265/index.html | 站内检索...",
    "webUrl": "http://www.hangzhou.gov.cn/art/2018/4/28/art_812265_17737003.html",
    "webSnapshot": "/20171226/00390/2355_5029222.html",
    "docUrl": "",
    "docSnapshot": "",
    "tmFetch": "2018-10-01 00:01:28",
    "handlerUser": 0,
    "einZip": 0,
    "eident": 1,
    "ealert": 1,
    "etype": 1,
    "estatus": 0
  }
```

备注 : codeOrg 代表区域编号,具体的区域编号与区域名映射关系在后面的文档更新中补充.

### 入网保密审查辅助平台(NSRS）

```json
{
    	    "platform":"平台名称",
    		"tmFetch":"数据抓取时间",
            "id":"第三方系统主键id",
            "deviceId": "设备ID",
            "allDepartName": "单位 部门",
            "registrant": "使用人",
            "devIp": "设备地址",
            "departId": "部门ID",
            "departName": "部门名称",
            "description": "违规说明",
            "repairedTime": "修复时间",
            "dealTime": "处理时间",
            "synTime": "同步时间",
            "isViolation": "0代表违规，未修复， 1代表已修复，3代表删除",
            "handleStatus": "处理过程",
            "coreId": "CoreID",
            "realCoreId": "RealCoreID",
            "policyId": "策略规范ID",
            "modifTime": "记录修改时间",
            "insertTime": "入库时间",
            "policyCoreId": "PolicyCoreID",
            "nextCoreId": "NextCoreID",
            "v1": "文件路径",
            "v2": "关键字",
            "v3": "关键字",
            "v4": "违规语句",
            "v5": "文件名称",
            "v6": "用户处理",
            "v7": "文件创建时间",
            "v8": "V8",
            "v9": "V9",
            "v10": "算法名称",
            "xml1": "违规段落",
            "xml2": "Xml2",
            "xml3": "Xml3",
            "content": "Content",
            "preCoreId": "PreCoreID",
            "processContent": "ProcessContent",
            "asRecordId": "序列号",
            "eventId": "事件编号",
            "tel": "电话",
            "checkItem": "违规类型",
            "violationTime": "违规时间",
    	    "devMac":"MAC地址"
}
```

```json
{
        "platform": "nsrs",
        "tmFetch": "2018-10-31 11:28:43",
        "id": 36,
        "departName": "test",
        "repairedTime": "2018-10-11 03:28:19",
        "dealTime": "2018-09-12 03:26:54",
        "synTime": "2018-10-25 03:28:24",
        "handleStatus": "1",
        "coreId": "2323",
        "realCoreId": "5",
        "policyId": "5",
        "modifTime": "2018-10-17 03:27:47",
        "insertTime": "2018-10-18 03:27:42",
        "policyCoreId": "34",
        "nextCoreId": "34",
        "v1": "2",
        "v2": "2",
        "v3": "3",
        "v4": null,
        "v5": null,
        "v6": null,
        "v7": null,
        "v8": null,
        "v9": null,
        "v10": "2",
        "xml1": "test",
        "xml2": null,
        "xml3": null,
        "content": "fdf",
        "preCoreId": "5",
        "processContent": "test",
        "asRecordId": "2",
        "allDepartName": "test1",
        "registrant": "1",
        "deviceId": 47,
        "departId": 32,
        "devIp": "102.188.22.32",
        "description": "test",
        "isViolation": 1,
        "eventId": "34",
        "tel": "1928923",
        "checkItem": "2",
        "violationTime": "2018-10-31 03:28:43",
        "devMac": null
    }
```

### 违规外联前端接口(VOMP)

```json
{
  		"recno":"序号",  					
  		"platform":"平台名",  					
  		"statId":"处理单号",  						
  		"tmFetch":"时间",  	
  		"unitName":"单位名称",  			
  		"deptment":"部⻔名称",  				
  		"tuser":"责任",  					
  		"hostName":"主机名",  					
  		"treserve":"转发",  					
  		"tos":"操作系统",  						
  		"tcard":"⽹卡信息", 									  
  		"macStr":"MAC地址",   		
  		"ipStr":"内⽹IP地址",   			
  		"outIpstr":"外⽹ip地址",   			
  		"masterCode":"主板序列号",  
  		"hdCode":"硬盘序列号",  			
  		"tmemo":"外联描述信息",
  		"statStatus":"状态:未处理，处理完成，删除，测试，更改，电话核查，主要案情，处理措施及整改情况，现场核查，关注",   					
  		"zoneName":"区域名",   
}
```

```json
{
  	"platform":"vomp", 
  	"tmFetch":"2011-1-1 11:11:11",  
  	"recno":13654,  					  	 					
  	"statId":"123",  						  		
    "unitName":"杭州市局",  				 
    "deptment":"公诉⼆科",  				 
  	"tuser":"张三",  					  
  	"hostName":"pgos",  					
  	"treserve":"SZJC",  					
  	"tos":"Win7",  						
  	"tcard":"[Marvell Yukon 88E8057 PCI-E Gigabit Ethernet Controller -数据包计划程序微型端口]",
  	"macStr":"F5 15 85 E6 37 44",   		
  	"ipStr":"192.168.1.1",			
  	"outIpstr":"20.1.1.1",			
  	"masterCode":"LENOVO To be filled by O.E.M SN:INVALID",
  	"hdCode":"123456HD",		
  	"tmemo":"经由⽹关[183.129.165.83]违规外联",
  	"statStatus":"未读",   					
    "zoneName":"浙江杭州市滨江区"		
}
```

### 网络数据库平台(NDSS)

```json
{
    "id":"id",   
    "platform":"系统名称,数据来源",		
    "orgName":"组织信息",			
    "resourceName":"检查数据库系统名称",		   
    "matchContent":"匹配内容,机密",		   
    "breachContent":"概要,匹配内容",	
    "tmFetch":"事件生成时间",	 
    "ip":"ip",				
    "sendTime":"报警时间",	
    "secretRate":"涉密概率",   
    "filename":"数据",      
    "filepath":"路径"       
}
```

```json
{
    "id":"adsd889912adad9dh7h",        
    "platform":"数据库检查平台",		  
    "orgName":"默认组织单位",			 
    "resourceName":"OA系统",		      
    "matchContent":"秘密",		      
    "breachContent":"这是概要123456",	
    "tmFetch":"2018-01-01 00:00:00",	
    "ip":"10.10.10.10",					
    "sendTime":"2011-01-01 00:00:00",	
    "secretRate":"8",                   
    "filename":"ads",                  
    "filepath":"/path/asd"            
}
```

### 特种木马监测(STMS)

- av查杀

```json
{
    "id":"id",                       
    "startTimeSec":"发现时间",		
    "clientIp":"客户端ip",	
    "clientPort":"客户端端口",	
    "clientMac":"客户端mac", 
    "serverIp":"服务器ip",	
    "serverPort":"服务器端口",		
    "serverMac":"服务器mac", 
    "protocol":"应用层协议",        
    "filenameOrigin":"查杀文件",
    "avResult":"报告摘要",         
    "avMessageFn":"查杀报告",
    "fileSize":"文件大小",			
    "fileName":"文件名称",
    "rawName":"原系统名称", 
    "newName":"数据类型"
}
```

```JSON
{
    "id":1,                          
    "startTimeSec":1509855203,		
    "clientIp":"192.168.1.141",		
    "clientPort":65140,			    
    "clientMac":"60:45:CB:6D:1E:FA",
    "serverIp":"124.193.0.38",		
    "serverPort":80,			   
    "serverMac":"50:6A:03:AB:C9:29", 
    "protocol":"http",              
    "filenameOrigin":"am_delta_patch_1.257.99.0_e64bb5e73665922041e2b2b66d50656028914e7e.exe",
    "avResult":"",                   
    "avMessageFn":"/2017-11-05/proto_http_download_file-1676-am_delta_patch_1.257.99.0_e64bb5e73665922041e2b2b66d50656028914e7e.exe.report",
    "fileSize":259856,				
    "fileName":"/2017-11-05/proto_http_download_file-1676-am_delta_patch_1.257.99.0_e64bb5e73665922041e2b2b66d50656028914e7e.exe",
    "rawName":"特种木马监控平台",      
    "newName":"av查杀"               
}
```

- 恶意程序

```json
{
    "id":"id",					
    "protocol":"应用层协议",           
    "prototree":"会话层协议",         
    "srcIp":"源ip地址",        
    "srcPort":"源端口号",          
    "destIp":"目标ip地址",        
    "destPort":"目标端口号",                
    "srcMac":"源Mac地址",     
    "destMac":"目标Mac地址",   
    "startTimeSec":"开始时间",    
    "endTimeSec":"结束时间",     
    "inByteCount":"进流量",           
    "outByteCount":"出流量",         
    "vInByteCount":"进有效流量",          
    "vOutByteCount":"出有效流量",      
    "inPackageCount":"进包数",        
    "outPackageCount":"出包数",      
    "yaraId":"恶意程序Id",     
    "categoryId":"恶意程序分类",          
    "yaraName":"恶意程序名称",    
    "allHttpInfo":"请求信息",        
    "rawName":"源系统名称",     
    "newName":"数据类型"     
}
```

```json
{
    "id":1,							
    "protocol":"",                
    "prototree":"TCP",            
    "srcIp":"10.54.64.152",       
    "srcPort":6716,             
    "destIp":"185.48.59.51",      
    "destPort":80,                 
    "srcMac":"38:91:D5:2E:5C:81",    
    "destMac":"38:97:D6:54:80:02", 
    "startTimeSec":1535731407,    
    "endTimeSec":1535731421,     
    "inByteCount":0,                
    "outByteCount":606,            
    "vInByteCount":0,              
    "vOutByteCount":354,            
    "inPackageCount":0,              
    "outPackageCount":4,            
    "yaraId":"ControlByMine",       
    "categoryId":6,                  
    "yaraName":"ControlByMine",      
    "allHttpInfo":"[]",              
    "rawName":"特种木马监控平台",    
    "newName":"恶意程序"             
}
```

- 黑DNS

```json
{
    "id":"id",                        
    "prototree":"会话层协议",           
    "srcIp":"源ip地址",         
    "srcPort":"源端口",           
    "destIp":"目标ip地址",    
    "descPort":"目标端口",                 
    "srcMac":"源Mac地址",    
    "destMac":"目标Mac地址",  
    "startTimeSec":"开始时间",      
    "endTimeSec":"结束时间",     
    "clientIp":"客户端ip",      
    "serverIp":"DNS服务器ip", 
    "requestOrResponses":"响应类型", 
    "dnsType":"域名类型",               
    "allDnsInfo":"请求详情",
 	"abnormalTypezh":"异常类型",  
    "blackDomainName":"恶意域名", 
    "blackDomainNameTop":"顶级域名",  
    "rawName":"源平台名称",      
    "newName":"数据类型"          
}
```

```json
{
    "id":1,                        
    "prototree":"UDP",             
    "srcIp":"10.54.64.149",         
    "srcPort":64128,                
    "destIp":"114.114.114.114",    
    "descPort":53,                   
    "srcMac":"38:91:D5:2E:5C:81",   
    "destMac":"38:97:D6:54:80:02",
    "startTimeSec":1535731224,     
    "endTimeSec":1535731224,      
    "clientIp":"10.54.64.149",    
    "serverIp":"114.114.114.114",   
    "requestOrResponses":"答应",     
    "dnsType":"A",                 
 	"abnormalTypezh":"黑域名",  	 
    "blackDomainName":"xmreu1.nanopool.org",  
    "blackDomainNameTop":".nanopool.org",     
    "rawName":"特种木马监控平台",            
    "newName":"恶意域名"                      
}
```

- 黑URL

```json
{
    "id":"id",                       
    "startTimeSec":"开始时间",     
    "clientIp":"客户端ip",     
    "clientPort":"客户端端口",             
    "clientMac":"客户端Mac",
    "serverIp":"服务器ip",     
    "serverPort":"服务器端口",             
    "serverMac":"服务器Mac", 
    "requestMethod":"请求类型",         
    "requestUrl":"请求url", 
    "requestReferer":"referer地址",            
    "requestHost":"请求主机",    
    "requestUserAgent":"User Agent",        
    "responseCode":"响应码",          
    "redirectUrl":"转向地址",            
    "rawName":"源系统名称",   
    "newName":"数据类型"        
}
```

```json
{
    "id":1,                          
    "startTimeSec":1509934867,       
    "clientIp":"192.168.1.164",      
    "clientPort":54907,              
    "clientMac":"60:45:CB:6D:1D:3D", 
    "serverIp":"119.29.29.29",      
    "serverPort":80,                 
    "serverMac":"50:6A:03:AB:C9:29", 
    "requestMethod":"GET",           
    "requestUrl":"http://119.29.29.29/d?dn=www.vip.com",  
    "requestReferer":"",             
    "requestHost":"119.29.29.29",    
    "requestUserAgent":"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.104 Safari/537.36 Core/1.53.3427.400 QQBrowser/9.6.12513.400",
    "responseCode":"200",           
    "redirectUrl":"",               
    "rawName":"特种木马监控平台",     
    "newName":"黑URL"         
}
```

- WebShell上传

```json
{
    "id":"id",                                    
    "startTimeSec":"开始时间",                  
    "clientIp":"客户端ip",                  
    "clientPort":"客户端端口",                           
    "clientMac":"客户端Mac",             
    "serverIp":"服务器ip",                 
    "serverPort":"服务器端口",                             
    "serverMac":"服务器Mac",           
    "requestMethod":"请求类型",               
    "requestUrl":"请求url",//请求url
    "requestReferer":"referer地址",                          
    "requestHost":"请求主机",             
    "requestUserAgent":"User Agent",  
    "responseCode":"相应码",                      
    "redirectUrl":"请求地址",                            
    "uploadOriginFn":"上传文件",         
    "uploadFileLen":"文件大小",                        
    "rawName":"源系统名称",              
    "newName":"数据类型"             
}
```

```json
{
    "id":1,                                      
    "startTimeSec":1531407319,                   
    "clientIp":"182.61.45.160",                   
    "clientPort":64955,                         
    "clientMac":"30:D1:7E:F1:51:33",             
    "serverIp":"106.38.3.37",                    
    "serverPort":80,                              
    "serverMac":"00:90:0B:3B:5D:A2",              
    "requestMethod":"POST",                      
    "requestUrl":"http://www.cnnc.com.cn/include/dialog/select_soft_post.php",
    "requestReferer":"",                         
    "requestHost":"www.cnnc.com.cn",              
    "requestUserAgent":"python-requests/2.19.1", 
    "responseCode":"403",                         
    "redirectUrl":"",                            
    "uploadOriginFn":"mklrktlfxbxm.php",         
    "uploadFileLen":69,                          
    "rawName":"特种木马监控平台",                  
    "newName":"WebShell上传"                      
}
```

- 黑mail

```json
{
    "id":1,
	"srcIp":"源IP地址",
	"srcPort":"源端口号",
	"destIp":"目的IP地址",
	"destPort":"目的端口号",
	"srcMac":"源MAC地址",
	"destMac":"目的MAC地址",
	"startTimeSec":1510024256,
	"endTimeSec":1510024257,
	"uid":"邮箱用户名",
	"pwd":"邮箱密码",
	"emlBodyLen":"邮件体大小",
	"attachmentCount":"附件个数",
	"emailTo":"接收地址",
 	"SUBJECT":"邮件标题",
 	"attachmentFilenames":"附件内容",
 	"blackEmail":"黑邮箱地址",
	"protocolzh":"协议名",
	"emailFrom":"发送地址 ",
	"rawName":"特种木马监控平台",
	"newName":"黑邮箱"
}
```

- 黑tcp

```json
{
    "id":1,
	"startTimeSec":"发现时间",
	"name":"劫持名称",
	"status":"劫持状态",
	"requestMethod":"请求类型",
	"srcIp":"客户端IP",
	"src_port":"客户端端口号",
	"responseCode":"返回代码",
	"destIp":"服务器IP",
	"destPort":"服务器端口号",
	"requestHost":"请求主机",
	"requestUrl":"请求地址",
	"requestUserAgent":"User Agent",
 	"requestReferer":"referer地址",
 	"redirectHost":"跳转主机",
 	"redirectUrl":"跳转地址",
	"rawName":"特种木马监控平台",
	"newName":"黑邮箱"
}
```

- 信息泄漏

```json
{
    "id":"id",                       
    "srcIp":"源ip地址",       
    "srcPort":"源端口地址",                
    "destIp":"目标ip地址",      
    "destPort":"目标端口",                 
    "srcMac":"源Mac地址",   
    "destMac":"目标Mac地址",  
    "startTimeSec":"开始时间",       
    "endTimeSec":"结束时间",         
    "discloseTypezh":"POST数据",     
    "description":"概要描述", 
    "summary":"内容摘要",                   
    "weight":"泄露权值",                    
    "wordFreq":"词汇名称",                  
    "domain":"上传网址",             
    "rawName":"源系统名称",     
    "newName":"数据类型"             
}
```

```json
{
    "id":1,                        
    "srcIp":"192.168.1.57",         
    "srcPort":64794,                
    "destIp":"182.254.20.108",      
    "destPort":80,                
    "srcMac":"34:97:F6:90:84:50",    
    "destMac":"50:6A:03:AB:C9:29",  
    "startTimeSec":1510024256,     
    "endTimeSec":1510024257,       
    "discloseTypezh":"POST数据",     
    "description":"上传网址: http://182.254.20.108/?ver=5545&ukey=50B5C1017262EAEF4A7CF8F3FEA989E1C829EB2553D19A7B994DB4CDBE199B10887D57A77D6F3EDFF28FC2EC3067805176BB502AFA85FF85AE359E2D5CD3A1EE6B77C33A8C8CAEB1B40A443B9D984F1A8263B9F97E26AF33B297B173F0FEE7E88EDAED416A92FE571AFA25BD8AA84C33DB4106095A1A29366E579B317E053C37D1394F367D810552C425C1C47EA1AA7960F5B32A5C56DFB58C991D037CCB161A5EA7569F847B08BCF8740EB49D718DF37B4ED895BF5788486A7268337296E6915B50875FA1B5567A43AC156A904949E3546FFA026B00D88F3D96FBAC5C055BFF55957AA95B67FD4DA5402D1D1A049EFDFAB8F158E5AE084838C2781512EAF2234102D494B48479533238ED314A3206A8DCC40697F709C04F2BAC977583DC2704B3BBDF3C339DAEB953BD59115983D71A&filekey=FD1E6E3E95AABD4B5877B9BB87999624&filesize=407737364&bmd5=41340D353B5153C82EFDB633928A017A&range=55836672&voice_codec=1#015#012Content-Type: #015#012Referer: ",
    "summary":"",                   
    "weight":4,                     
    "wordFreq":"1",                  
    "domain":"密文:1 ",              
    "rawName":"特种木马监控平台",    
    "newName":"信息泄露"            
}
```

- 黑ip

```json
{
    "id":"id",                       
    "protocol":"应用层协议",          
    "prototree":"会话层协议",              
    "srcIp":"源Ip地址",      
    "srcPort":"源端口号",              
    "destIp":"目标Ip地址",        
    "destPort":"目标端口号",              
    "srcMac":"源Mac地址",   
    "destMac":"目标Mac地址", 
    "startTimeSec":"开始时间",     
    "endTimeSec":"结束时间",       
    "inByteCount":"进流量",             
    "outByteCount":"出流量",            
    "vinByteCount":"进有效流量",            
    "voutByteCount":"出有效流量",          
    "inPackageCount":"进包数",           
    "outPackageCount":"出包数",         
    "blackIp":"黑IP",     
    "clientIp":"客户端IP",     
    "blackIpFromzh":"黑IP来源",
    "rawName":"源系统名称",    
    "newName":"数据类型"          
}
```

```json
{
    "id":1,                        
    "protocol":"",                 
    "prototree":"TCP",            
    "srcIp":"151.80.144.253",      
    "srcPort":14444,               
    "destIp":"10.54.64.149",        
    "destPort":41143,             
    "srcMac":"38:97:D6:54:80:02",  
    "destMac":"38:91:D5:2E:5C:81",  
    "startTimeSec":1535731224,   
    "endTimeSec":1535731228,      
    "inByteCount":529,             
    "outByteCount":0,             
    "vinByteCount":277,            
    "voutByteCount":0,            
    "inPackageCount":4,            
    "outPackageCount":0,           
    "blackIp":"151.80.144.253",    
    "clientIp":"10.54.64.149",      
    "blackIpFromzh":"黑域名解析出的",
    "rawName":"特种木马监控平台",   
    "newName":"黑IP"               
}
```