create table kt_action
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    name        varchar(255)                          null,
    move_id     bigint(11)                            null comment '行为ID',
    project_id  bigint(11)                            null comment '项目ID',
    remark      text                                  null comment '备注',
    type        int                                   null comment '类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME',
    env_id      bigint(11)                            null comment '环境id',
    detail      text                                  null comment '详细参数',
    create_time timestamp default current_timestamp() not null comment '数据创建时间',
    update_time timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '动作表,包含了实际的动作参数' engine = InnoDB;

create index fk_active_move
    on kt_action (move_id);

create table kt_change
(
    type   varchar(11)  null,
    entity varchar(255) null,
    id     varchar(255) null
);

create table kt_connect
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    name        varchar(255)                          null comment '名称',
    url         varchar(255)                          null comment 'URL',
    username    varchar(255)                          null comment '账号',
    password    varchar(255)                          null comment '密码',
    driver      varchar(255)                          null comment '所用驱动',
    create_time timestamp default current_timestamp() not null comment '数据创建时间',
    update_time timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间',
    project_id  bigint                                null comment '项目id'
)
    comment '连接表,包含里连接数据源所需要的参数' engine = InnoDB;

create table kt_dynamic_variable
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    project_id  bigint(11)                            null comment '所属项目',
    taken_field varchar(255)                          null comment '取用字段',
    name        varchar(255)                          null comment '名称',
    type        int                                   not null comment '动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP',
    remark      varchar(510)                          null comment '备注',
    detail      text                                  null comment '详细内容',
    create_time timestamp default current_timestamp() not null comment '数据创建时间',
    update_time timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '动态变量表,用于表示数值会发生变化的变量' engine = InnoDB;

create index fk_project_dynamicVariable
    on kt_dynamic_variable (project_id);

create table kt_environment
(
    id             bigint(11) auto_increment comment 'ID'
        primary key,
    name           varchar(255)                          null comment '实例名称',
    parameter_name varchar(255)                          null comment '参数名 （例如：env）',
    project_id     bigint(11)                            null comment '项目ID',
    variable       text                                  null comment '静态变量，以JSON的形式存储，例如（{"name":"张三"}）',
    is_default     tinyint(255)                          null comment '是否为默认',
    ip             varchar(255)                          null comment 'ip,例如（http:www.abc.com）',
    create_time    timestamp default current_timestamp() not null comment '数据创建时间',
    update_time    timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '实例表，项目对应的环境实例，例如：实验室环境，开发环境等' engine = InnoDB;

create index fk_project_case
    on kt_environment (project_id);

create table kt_execution_history
(
    id                     bigint auto_increment comment 'ID'
        primary key,
    unique_key             varchar(255)                          null comment '执行的批次号',
    user_id                bigint                                null comment '用户id',
    case_id                bigint                                null comment '用例ID',
    data_id                bigint                                null comment '用例数据组ID',
    job_id                 bigint                                null comment '测试任务ID',
    execution_key          bigint                                null comment '执行号，例如：#1',
    status                 int                                   null comment '0:准备阶段，1:执行阶段，2:执行完成，3:执行异常',
    create_time            timestamp default current_timestamp() null,
    update_time            timestamp default current_timestamp() null on update current_timestamp(),
    start_time             timestamp                             null,
    end_time               timestamp                             null,
    url                    varchar(1024)                         null,
    case_execute_vo_string text                                  null
)
    comment '执行记录历史表,记录执行过程中的历史日志' engine = InnoDB
                                   collate = utf8_bin;

create table kt_execution_record
(
    id           bigint(11) auto_increment comment 'ID'
        primary key,
    user_id      bigint(11)                            null comment '用户id',
    test_job_id  bigint                                null comment '测试任务id',
    test_case_id bigint                                null comment '测试用例id',
    test_data_id bigint                                null comment '测试数据id',
    type         varchar(255)                          null comment '类型',
    unique_key   varchar(255)                          null comment 'key用来记录执行批次',
    log          longtext                              null comment '日志',
    create_time  timestamp default current_timestamp() not null comment '数据创建时间',
    update_time  timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '执行记录表,记录用例执行过程中的日志' engine = InnoDB;

create table kt_move
(
    id          bigint(11) auto_increment comment 'ID'
        primary key,
    name        varchar(255)                          null comment '名称',
    project_id  bigint(11)                            null comment '所属项目',
    move_type   int                                   null,
    remark      text                                  null comment '备注',
    create_time timestamp default current_timestamp() not null comment '数据创建时间',
    update_time timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '行为表,作为动作表的父级,根据环境来决定行为实例的动作是什么' engine = InnoDB;

create index fk_move_project
    on kt_move (project_id);

create table kt_project
(
    id          bigint auto_increment comment 'ID'
        primary key,
    name        varchar(255)                          null comment '名称',
    create_time timestamp default current_timestamp() not null comment '数据创建时间',
    update_time timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '项目表,数据由读取禅道获得' engine = InnoDB;

create table kt_test_case
(
    id              bigint(11) auto_increment comment 'ID'
        primary key,
    name            varchar(255)                          null comment '名称',
    project_id      bigint(11)                            null comment '所属项目',
    type            int                                   not null comment '用例类型 1为http',
    detail          text                                  null comment '详细参数',
    move_before     varchar(255)                          null comment '前置行动ID组，例如：1，2，3',
    move_after_case varchar(255)                          null comment '后置行动ID组，例如：1，2，3',
    move_after_test varchar(255)                          null comment '测试执行后行动ID组，例如：1，2，3',
    des             varchar(255)                          null comment '用例描述',
    default_env     bigint                                null comment '默认使用环境',
    tag             varchar(50)                           null comment '标签信息',
    create_time     timestamp default current_timestamp() not null comment '数据创建时间',
    update_time     timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间',
    ret_value       text                                  null comment '返回值信息'
)
    comment '测试用例表，测试的平台的主体数据' engine = InnoDB;

create index fk_case_project
    on kt_test_case (project_id);

create table kt_test_data
(
    id                    bigint auto_increment comment '主键id'
        primary key,
    name                  varchar(255)                          null comment '名称',
    abnormal_checkpoint   int                                   not null comment '是否进行异常检验,0为否,1为是',
    no_empty_checkpoint   int                                   not null comment '是否进行非空检验,0为否,1为是',
    contain_checkpoint    text                                  null comment '包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四',
    no_contain_checkpoint text                                  null comment '不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四',
    database_checkpoint   text                                  null comment '数据库检验点，以JSON形式存放',
    jsonpath_checkpoint   text                                  null comment 'jsonpath检验点，以json形式存放',
    detail                longtext                              null comment '详细参数',
    test_case_id          bigint                                not null comment '关联的测试用例的id',
    create_time           timestamp default current_timestamp() not null comment '数据创建时间',
    update_time           timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间'
)
    comment '测试接口的一组数据' engine = InnoDB;

create table kt_test_job
(
    id            bigint(11) auto_increment comment 'ID'
        primary key,
    name          varchar(255)                          null comment '名称',
    remark        varchar(510)                          null comment '备注',
    project_id    bigint                                null comment '项目ID',
    sql_statement text                                  null comment 'sql语句',
    create_time   timestamp default current_timestamp() not null comment '数据创建时间',
    update_time   timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间',
    find_type     int                                   null comment '0,保存sql,1,保存'
)
    comment '测试任务表,用于选取某一组要测试的测试用例' engine = InnoDB;

create table kt_user
(
    id          bigint(11)                            not null
        primary key,
    create_time timestamp default current_timestamp() not null comment '数据创建时间',
    update_time timestamp default current_timestamp() not null on update current_timestamp() comment '数据更新时间',
    name        varchar(255)                          null,
    account     varchar(255)                          null,
    password    varchar(255)                          null
)
    comment '用户表,数据由读取禅道获得' engine = InnoDB;

create table kt_user_project
(
    id         bigint(11) auto_increment
        primary key,
    user_id    bigint(11) null,
    project_id bigint(11) null
)
    comment '用户表与数据表的中间表,用来记录多对多的记录关系' engine = InnoDB;

create table zt_project
(
    id             mediumint unsigned auto_increment
        primary key,
    project        mediumint(8)              default 0        not null,
    model          char(30)                                   not null,
    type           char(30)                  default 'sprint' not null,
    lifetime       char(30)                  default ''       not null,
    budget         varchar(30)               default '0'      not null,
    budgetUnit     char(30)                  default 'CNY'    not null,
    attribute      varchar(30)               default ''       not null,
    percent        float unsigned            default 0        not null,
    milestone      enum ('0', '1')           default '0'      not null,
    output         text                                       not null,
    auth           char(30)                                   not null,
    parent         mediumint unsigned        default 0        not null,
    path           varchar(255)                               not null,
    grade          tinyint unsigned                           not null,
    name           varchar(90)                                not null,
    code           varchar(45)                                not null,
    begin          date                                       not null,
    end            date                                       not null,
    realBegan      date                                       not null,
    realEnd        date                                       not null,
    days           smallint(5) unsigned                       not null,
    status         varchar(10)                                not null,
    subStatus      varchar(30)               default ''       not null,
    pri            enum ('1', '2', '3', '4') default '1'      not null,
    `desc`         text                                       not null,
    version        smallint(6)                                not null,
    parentVersion  smallint(6)                                not null,
    planDuration   int                                        not null,
    realDuration   int                                        not null,
    openedBy       varchar(30)               default ''       not null,
    openedDate     datetime                                   not null,
    openedVersion  varchar(20)                                not null,
    lastEditedBy   varchar(30)               default ''       not null,
    lastEditedDate datetime                                   not null,
    closedBy       varchar(30)               default ''       not null,
    closedDate     datetime                                   not null,
    canceledBy     varchar(30)               default ''       not null,
    canceledDate   datetime                                   not null,
    PO             varchar(30)               default ''       not null,
    PM             varchar(30)               default ''       not null,
    QD             varchar(30)               default ''       not null,
    RD             varchar(30)               default ''       not null,
    team           varchar(90)                                not null,
    acl            char(30)                  default 'open'   not null,
    whitelist      text                                       not null,
    `order`        mediumint unsigned                         not null,
    deleted        enum ('0', '1')           default '0'      not null
);

create index acl
    on zt_project (acl);

create index begin
    on zt_project (begin);

create index end
    on zt_project (end);

create index `order`
    on zt_project (`order`);

create index parent
    on zt_project (parent);

create index status
    on zt_project (status);

create table zt_user
(
    id           mediumint unsigned auto_increment
        primary key,
    company      mediumint unsigned                                                                  not null,
    type         char(30)                                              default 'inside'              not null,
    dept         mediumint unsigned                                    default 0                     not null,
    account      char(30)                                              default ''                    not null,
    password     char(32)                                              default ''                    not null,
    role         char(10)                                              default ''                    not null,
    realname     varchar(100)                                          default ''                    not null,
    pinyin       varchar(255)                                          default ''                    not null,
    nickname     char(60)                                              default ''                    not null,
    commiter     varchar(100)                                                                        not null,
    avatar       text                                                                                not null,
    birthday     date                                                  default '0000-00-00'          not null,
    gender       enum ('f', 'm')                                       default 'f'                   not null,
    email        char(90)                                              default ''                    not null,
    skype        char(90)                                              default ''                    not null,
    qq           char(20)                                              default ''                    not null,
    mobile       char(11)                                              default ''                    not null,
    phone        char(20)                                              default ''                    not null,
    weixin       varchar(90)                                           default ''                    not null,
    dingding     varchar(90)                                           default ''                    not null,
    slack        varchar(90)                                           default ''                    not null,
    whatsapp     varchar(90)                                           default ''                    not null,
    address      char(120)                                             default ''                    not null,
    zipcode      char(10)                                              default ''                    not null,
    nature       text                                                                                not null,
    analysis     text                                                                                not null,
    strategy     text                                                                                not null,
    `join`       date                                                  default '0000-00-00'          not null,
    visits       mediumint unsigned                                    default 0                     not null,
    ip           char(15)                                              default ''                    not null,
    last         int unsigned                                          default 0                     not null,
    fails        tinyint(5)                                            default 0                     not null,
    locked       datetime                                              default '0000-00-00 00:00:00' not null,
    ranzhi       char(30)                                              default ''                    not null,
    score        int                                                   default 0                     not null,
    scoreLevel   int                                                   default 0                     not null,
    deleted      enum ('0', '1')                                       default '0'                   not null,
    clientStatus enum ('online', 'away', 'busy', 'offline', 'meeting') default 'offline'             not null,
    clientLang   varchar(10)                                           default 'zh-cn'               not null,
    constraint account
        unique (account)
);

create index commiter
    on zt_user (commiter);

create index deleted
    on zt_user (deleted);

create index dept
    on zt_user (dept);

create index email
    on zt_user (email);

create table zt_userview
(
    account  char(30)   not null,
    programs mediumtext not null,
    products mediumtext not null,
    projects mediumtext not null,
    sprints  mediumtext not null,
    constraint account
        unique (account)
);


