create table kt_change
(
    type   varchar(11)  null,
    entity varchar(255) null,
    id     varchar(255) null
);

create table zt_acl
(
    id         mediumint auto_increment
        primary key,
    account    char(30)                      not null,
    objectType char(30)                      not null,
    objectID   mediumint default 0           not null,
    type       char(40)  default 'whitelist' not null,
    source     char(30)                      not null
);

create table zt_action
(
    id         mediumint unsigned auto_increment
        primary key,
    objectType varchar(30)        default ''  not null,
    objectID   mediumint unsigned default 0   not null,
    product    varchar(255)                   not null,
    project    mediumint unsigned             not null,
    execution  mediumint unsigned             not null,
    actor      varchar(100)       default ''  not null,
    action     varchar(30)        default ''  not null,
    date       datetime                       not null,
    comment    text                           not null,
    extra      text                           not null,
    `read`     enum ('0', '1')    default '0' not null
);

create index action
    on zt_action (action);

create index actor
    on zt_action (actor);

create index date
    on zt_action (date);

create index objectID
    on zt_action (objectID);

create index project
    on zt_action (project);

create table zt_block
(
    id      mediumint unsigned auto_increment
        primary key,
    account char(30)                       not null,
    module  varchar(20)                    not null,
    type    char(30)                       not null,
    title   varchar(100)                   not null,
    source  varchar(20)                    not null,
    block   varchar(20)                    not null,
    params  text                           not null,
    `order` tinyint unsigned     default 0 not null,
    grid    tinyint unsigned     default 0 not null,
    height  smallint(5) unsigned default 0 not null,
    hidden  tinyint(1) unsigned  default 0 not null,
    constraint account_module_type_order
        unique (account, module, type, `order`)
);

create index account
    on zt_block (account);

create table zt_branch
(
    id      mediumint unsigned auto_increment
        primary key,
    product mediumint unsigned          not null,
    name    varchar(255)                not null,
    `order` smallint(5) unsigned        not null,
    deleted enum ('0', '1') default '0' not null
);

create index product
    on zt_branch (product);

create table zt_bug
(
    id             mediumint(8) auto_increment
        primary key,
    project        mediumint unsigned                                     not null,
    product        mediumint unsigned                    default 0        not null,
    branch         mediumint unsigned                    default 0        not null,
    module         mediumint unsigned                    default 0        not null,
    execution      mediumint unsigned                    default 0        not null,
    plan           mediumint unsigned                    default 0        not null,
    story          mediumint unsigned                    default 0        not null,
    storyVersion   smallint(6)                           default 1        not null,
    task           mediumint unsigned                    default 0        not null,
    toTask         mediumint unsigned                    default 0        not null,
    toStory        mediumint(8)                          default 0        not null,
    title          varchar(255)                                           not null,
    keywords       varchar(255)                                           not null,
    severity       tinyint                               default 0        not null,
    pri            tinyint unsigned                                       not null,
    type           varchar(30)                           default ''       not null,
    os             varchar(30)                           default ''       not null,
    browser        varchar(30)                           default ''       not null,
    hardware       varchar(30)                                            not null,
    found          varchar(30)                           default ''       not null,
    steps          text                                                   not null,
    status         enum ('active', 'resolved', 'closed') default 'active' not null,
    subStatus      varchar(30)                           default ''       not null,
    color          char(7)                                                not null,
    confirmed      tinyint(1)                            default 0        not null,
    activatedCount smallint(6)                                            not null,
    activatedDate  datetime                                               not null,
    mailto         text                                                   null,
    openedBy       varchar(30)                           default ''       not null,
    openedDate     datetime                                               not null,
    openedBuild    varchar(255)                                           not null,
    assignedTo     varchar(30)                           default ''       not null,
    assignedDate   datetime                                               not null,
    deadline       date                                                   not null,
    resolvedBy     varchar(30)                           default ''       not null,
    resolution     varchar(30)                           default ''       not null,
    resolvedBuild  varchar(30)                           default ''       not null,
    resolvedDate   datetime                                               not null,
    closedBy       varchar(30)                           default ''       not null,
    closedDate     datetime                                               not null,
    duplicateBug   mediumint unsigned                                     not null,
    linkBug        varchar(255)                                           not null,
    `case`         mediumint unsigned                                     not null,
    caseVersion    smallint(6)                           default 1        not null,
    result         mediumint unsigned                                     not null,
    repo           mediumint unsigned                                     not null,
    entry          varchar(255)                                           not null,
    `lines`        varchar(10)                                            not null,
    v1             varchar(40)                                            not null,
    v2             varchar(40)                                            not null,
    repoType       varchar(30)                           default ''       not null,
    testtask       mediumint unsigned                                     not null,
    lastEditedBy   varchar(30)                           default ''       not null,
    lastEditedDate datetime                                               not null,
    deleted        enum ('0', '1')                       default '0'      not null
);

create index assignedTo
    on zt_bug (assignedTo);

create index `case`
    on zt_bug (`case`);

create index execution
    on zt_bug (execution);

create index plan
    on zt_bug (plan);

create index product
    on zt_bug (product);

create index result
    on zt_bug (result);

create index status
    on zt_bug (status);

create index story
    on zt_bug (story);

create index toStory
    on zt_bug (toStory);

create table zt_build
(
    id        mediumint unsigned auto_increment
        primary key,
    project   mediumint unsigned             not null,
    product   mediumint unsigned default 0   not null,
    branch    mediumint unsigned default 0   not null,
    execution mediumint unsigned default 0   not null,
    name      char(150)                      not null,
    scmPath   char(255)                      not null,
    filePath  char(255)                      not null,
    date      date                           not null,
    stories   text                           not null,
    bugs      text                           not null,
    builder   char(30)           default ''  not null,
    `desc`    text                           not null,
    deleted   enum ('0', '1')    default '0' not null
);

create index execution
    on zt_build (execution);

create index product
    on zt_build (product);

create table zt_burn
(
    execution  mediumint unsigned           not null,
    product    mediumint unsigned           not null,
    task       mediumint unsigned default 0 not null,
    date       date                         not null,
    estimate   float                        not null,
    `left`     float                        not null,
    consumed   float                        not null,
    storyPoint float                        not null,
    primary key (execution, date, task)
);

create table zt_case
(
    id              mediumint unsigned auto_increment
        primary key,
    project         mediumint unsigned                  not null,
    product         mediumint unsigned     default 0    not null,
    execution       mediumint unsigned                  not null,
    branch          mediumint unsigned     default 0    not null,
    lib             mediumint unsigned     default 0    not null,
    module          mediumint unsigned     default 0    not null,
    path            mediumint unsigned     default 0    not null,
    story           mediumint(30) unsigned default 0    not null,
    storyVersion    smallint(6)            default 1    not null,
    title           varchar(255)                        not null,
    precondition    text                                not null,
    keywords        varchar(255)                        not null,
    pri             tinyint unsigned       default 3    not null,
    type            char(30)               default '1'  not null,
    auto            varchar(10)            default 'no' not null,
    frame           varchar(10)                         not null,
    stage           varchar(255)                        not null,
    howRun          varchar(30)                         not null,
    scriptedBy      varchar(30)                         not null,
    scriptedDate    date                                not null,
    scriptStatus    varchar(30)                         not null,
    scriptLocation  varchar(255)                        not null,
    status          char(30)               default '1'  not null,
    subStatus       varchar(30)            default ''   not null,
    color           char(7)                             not null,
    frequency       enum ('1', '2', '3')   default '1'  not null,
    `order`         tinyint(30) unsigned   default 0    not null,
    openedBy        char(30)               default ''   not null,
    openedDate      datetime                            not null,
    reviewedBy      varchar(255)                        not null,
    reviewedDate    date                                not null,
    lastEditedBy    char(30)               default ''   not null,
    lastEditedDate  datetime                            not null,
    version         tinyint unsigned       default 0    not null,
    linkCase        varchar(255)                        not null,
    fromBug         mediumint unsigned                  not null,
    fromCaseID      mediumint unsigned                  not null,
    fromCaseVersion mediumint unsigned     default 1    not null,
    deleted         enum ('0', '1')        default '0'  not null,
    lastRunner      varchar(30)                         not null,
    lastRunDate     datetime                            not null,
    lastRunResult   char(30)                            not null
);

create index fromBug
    on zt_case (fromBug);

create index module
    on zt_case (module);

create index product
    on zt_case (product);

create index story
    on zt_case (story);

create table zt_casestep
(
    id      mediumint unsigned auto_increment
        primary key,
    parent  mediumint unsigned   default 0      not null,
    `case`  mediumint unsigned   default 0      not null,
    version smallint(3) unsigned default 0      not null,
    type    varchar(10)          default 'step' not null,
    `desc`  text                                not null,
    expect  text                                not null
);

create index `case`
    on zt_casestep (`case`);

create index version
    on zt_casestep (version);

create table zt_company
(
    id       mediumint unsigned auto_increment
        primary key,
    name     char(120)                   null,
    phone    char(20)                    null,
    fax      char(20)                    null,
    address  char(120)                   null,
    zipcode  char(10)                    null,
    website  char(120)                   null,
    backyard char(120)                   null,
    guest    enum ('1', '0') default '0' not null,
    admins   char(255)                   null,
    deleted  enum ('0', '1') default '0' not null
);

create table zt_compile
(
    id          mediumint unsigned auto_increment
        primary key,
    name        varchar(50)                  not null,
    job         mediumint unsigned           not null,
    queue       mediumint(8)                 not null,
    status      varchar(255)                 not null,
    logs        text                         null,
    atTime      varchar(10)                  not null,
    testtask    mediumint unsigned           not null,
    tag         varchar(255)                 not null,
    times       tinyint unsigned default 0   not null,
    createdBy   varchar(30)                  not null,
    createdDate datetime                     not null,
    updateDate  datetime                     not null,
    deleted     enum ('0', '1')  default '0' not null
);

create table zt_config
(
    id      mediumint unsigned auto_increment
        primary key,
    owner   char(30) default '' not null,
    module  varchar(30)         not null,
    section char(30) default '' not null,
    `key`   char(30) default '' not null,
    value   longtext            not null,
    constraint `unique`
        unique (owner, module, section, `key`)
);

create table zt_cron
(
    id       mediumint unsigned auto_increment
        primary key,
    m        varchar(20)          not null,
    h        varchar(20)          not null,
    dom      varchar(20)          not null,
    mon      varchar(20)          not null,
    dow      varchar(20)          not null,
    command  text                 not null,
    remark   varchar(255)         not null,
    type     varchar(20)          not null,
    buildin  tinyint(1) default 0 not null,
    status   varchar(20)          not null,
    lastTime datetime             not null
);

create index lastTime
    on zt_cron (lastTime);

create table zt_dept
(
    id       mediumint unsigned auto_increment
        primary key,
    name     char(60)                      not null,
    parent   mediumint unsigned default 0  not null,
    path     char(255)          default '' not null,
    grade    tinyint unsigned   default 0  not null,
    `order`  smallint unsigned  default 0  not null,
    position char(30)           default '' not null,
    function char(255)          default '' not null,
    manager  char(30)           default '' not null
);

create index parent
    on zt_dept (parent);

create index path
    on zt_dept (path);

create table zt_doc
(
    id         mediumint unsigned auto_increment
        primary key,
    project    mediumint unsigned                  not null,
    product    mediumint unsigned                  not null,
    execution  mediumint unsigned                  not null,
    lib        varchar(30)                         not null,
    module     varchar(30)                         not null,
    title      varchar(255)                        not null,
    keywords   varchar(255)                        not null,
    type       varchar(30)                         not null,
    views      smallint(5) unsigned                not null,
    draft      longtext                            not null,
    collector  text                                not null,
    addedBy    varchar(30)                         not null,
    addedDate  datetime                            not null,
    editedBy   varchar(30)                         not null,
    editedDate datetime                            not null,
    mailto     text                                null,
    acl        varchar(10)          default 'open' not null,
    `groups`   varchar(255)                        not null,
    users      text                                not null,
    version    smallint(5) unsigned default 1      not null,
    deleted    enum ('0', '1')      default '0'    not null
);

create index execution
    on zt_doc (execution);

create index lib
    on zt_doc (lib);

create index product
    on zt_doc (product);

create table zt_doccontent
(
    id      mediumint unsigned auto_increment
        primary key,
    doc     mediumint unsigned   not null,
    title   varchar(255)         not null,
    digest  varchar(255)         not null,
    content longtext             not null,
    files   text                 not null,
    type    varchar(10)          not null,
    version smallint(5) unsigned not null,
    constraint doc_version
        unique (doc, version)
);

create table zt_doclib
(
    id        smallint(5) unsigned auto_increment
        primary key,
    type      varchar(30)                    not null,
    product   mediumint unsigned             not null,
    project   mediumint unsigned             not null,
    execution mediumint unsigned             not null,
    name      varchar(60)                    not null,
    acl       varchar(10)     default 'open' not null,
    `groups`  varchar(255)                   not null,
    users     text                           not null,
    main      enum ('0', '1') default '0'    not null,
    collector text                           not null,
    `order`   tinyint(5) unsigned            not null,
    deleted   enum ('0', '1') default '0'    not null
);

create index execution
    on zt_doclib (execution);

create index product
    on zt_doclib (product);

create table zt_effort
(
    id      mediumint unsigned auto_increment
        primary key,
    user    char(30)             default ''                    not null,
    todo    enum ('1', '0')      default '1'                   not null,
    date    date                                               not null,
    begin   datetime             default '0000-00-00 00:00:00' not null,
    end     datetime             default '0000-00-00 00:00:00' not null,
    type    enum ('1', '2', '3') default '1'                   not null,
    idvalue mediumint unsigned   default 0                     not null,
    name    char(30)             default ''                    not null,
    `desc`  char(255)            default ''                    not null,
    status  enum ('1', '2', '3') default '1'                   not null
);

create index user
    on zt_effort (user);

create table zt_entry
(
    id          mediumint unsigned auto_increment
        primary key,
    name        varchar(50)                 not null,
    account     varchar(30)     default ''  not null,
    code        varchar(20)                 not null,
    `key`       varchar(32)                 not null,
    freePasswd  enum ('0', '1') default '0' not null,
    ip          varchar(100)                not null,
    `desc`      text                        not null,
    createdBy   varchar(30)                 not null,
    createdDate datetime                    not null,
    calledTime  int unsigned    default 0   not null,
    editedBy    varchar(30)                 not null,
    editedDate  datetime                    not null,
    deleted     enum ('0', '1') default '0' not null
);

create table zt_expect
(
    id          mediumint(8) auto_increment
        primary key,
    userID      mediumint(8)                not null,
    project     mediumint(8)    default 0   not null,
    expect      text                        not null,
    progress    text                        not null,
    createdBy   char(30)                    not null,
    createdDate date                        not null,
    deleted     enum ('0', '1') default '0' not null
);

create table zt_extension
(
    id               mediumint unsigned auto_increment
        primary key,
    name             varchar(150)                    not null,
    code             varchar(30)                     not null,
    version          varchar(50)                     not null,
    author           varchar(100)                    not null,
    `desc`           text                            not null,
    license          text                            not null,
    type             varchar(20) default 'extension' not null,
    site             varchar(150)                    not null,
    zentaoCompatible varchar(100)                    not null,
    installedTime    datetime                        not null,
    depends          varchar(100)                    not null,
    dirs             mediumtext                      not null,
    files            mediumtext                      not null,
    status           varchar(20)                     not null,
    constraint code
        unique (code)
);

create index installedTime
    on zt_extension (installedTime);

create index name
    on zt_extension (name);

create table zt_file
(
    id         mediumint unsigned auto_increment
        primary key,
    pathname   char(100)                      not null,
    title      char(255)                      not null,
    extension  char(30)                       not null,
    size       int unsigned       default 0   not null,
    objectType char(30)                       not null,
    objectID   mediumint                      not null,
    addedBy    char(30)           default ''  not null,
    addedDate  datetime                       not null,
    downloads  mediumint unsigned default 0   not null,
    extra      varchar(255)                   not null,
    deleted    enum ('0', '1')    default '0' not null
);

create index objectID
    on zt_file (objectID);

create index objectType
    on zt_file (objectType);

create table zt_group
(
    id      mediumint unsigned auto_increment
        primary key,
    project mediumint unsigned default 0  not null,
    name    char(30)                      not null,
    role    char(30)           default '' not null,
    `desc`  char(255)          default '' not null,
    acl     text                          null
);

create table zt_grouppriv
(
    `group` mediumint unsigned default 0  not null,
    module  char(30)           default '' not null,
    method  char(30)           default '' not null,
    constraint `group`
        unique (`group`, module, method)
);

create table zt_history
(
    id     mediumint unsigned auto_increment
        primary key,
    action mediumint unsigned default 0  not null,
    field  varchar(30)        default '' not null,
    old    text                          not null,
    new    text                          not null,
    diff   mediumtext                    not null
);

create index action
    on zt_history (action);

create table zt_im_chat
(
    id             mediumint unsigned auto_increment
        primary key,
    gid            char(40)           default ''                    not null,
    name           varchar(60)        default ''                    not null,
    type           varchar(20)        default 'group'               not null,
    admins         varchar(255)       default ''                    not null,
    committers     varchar(255)       default ''                    not null,
    subject        mediumint unsigned default 0                     not null,
    public         enum ('0', '1')    default '0'                   not null,
    createdBy      varchar(30)        default ''                    not null,
    createdDate    datetime           default '0000-00-00 00:00:00' not null,
    editedBy       varchar(30)        default ''                    not null,
    editedDate     datetime           default '0000-00-00 00:00:00' not null,
    lastActiveTime datetime           default '0000-00-00 00:00:00' not null,
    lastMessage    int(11) unsigned   default 0                     not null,
    dismissDate    datetime           default '0000-00-00 00:00:00' not null,
    pinnedMessages text               default ''                    not null
);

create index createdBy
    on zt_im_chat (createdBy);

create index editedBy
    on zt_im_chat (editedBy);

create index gid
    on zt_im_chat (gid);

create index name
    on zt_im_chat (name);

create index public
    on zt_im_chat (public);

create index type
    on zt_im_chat (type);

create table zt_im_chat_message_index
(
    id        mediumint unsigned auto_increment
        primary key,
    gid       char(40)                               not null,
    tableName char(64)                               not null,
    start     int(11) unsigned                       not null,
    end       int(11) unsigned                       not null,
    startDate datetime default '0000-00-00 00:00:00' not null,
    endDate   datetime default '0000-00-00 00:00:00' not null,
    count     mediumint unsigned                     not null,
    constraint chattable
        unique (gid, tableName)
);

create index end
    on zt_im_chat_message_index (end);

create index endDate
    on zt_im_chat_message_index (endDate);

create index start
    on zt_im_chat_message_index (start);

create index startDate
    on zt_im_chat_message_index (startDate);

create table zt_im_chatuser
(
    id              mediumint unsigned auto_increment
        primary key,
    cgid            char(40)         default ''                    not null,
    user            mediumint(8)     default 0                     not null,
    `order`         smallint         default 0                     not null,
    star            enum ('0', '1')  default '0'                   not null,
    hide            enum ('0', '1')  default '0'                   not null,
    mute            enum ('0', '1')  default '0'                   not null,
    freeze          enum ('0', '1')  default '0'                   not null,
    `join`          datetime         default '0000-00-00 00:00:00' not null,
    quit            datetime         default '0000-00-00 00:00:00' not null,
    category        varchar(40)      default ''                    not null,
    lastReadMessage int(11) unsigned default 0                     not null,
    constraint chatuser
        unique (cgid, user)
);

create index cgid
    on zt_im_chatuser (cgid);

create index hide
    on zt_im_chatuser (hide);

create index `order`
    on zt_im_chatuser (`order`);

create index star
    on zt_im_chatuser (star);

create index user
    on zt_im_chatuser (user);

create table zt_im_client
(
    id          int(11) unsigned auto_increment
        primary key,
    version     char(30)                  default ''     not null,
    `desc`      varchar(100)              default ''     not null,
    changeLog   text                                     not null,
    strategy    varchar(10)               default ''     not null,
    downloads   text                                     not null,
    createdDate datetime                                 not null,
    createdBy   varchar(30)               default ''     not null,
    editedDate  datetime                                 not null,
    editedBy    varchar(30)               default ''     not null,
    status      enum ('released', 'wait') default 'wait' not null
);

create table zt_im_conference
(
    id           mediumint unsigned auto_increment
        primary key,
    rid          char(24)                default ''                    not null,
    cgid         char(40)                default ''                    not null,
    status       enum ('closed', 'open') default 'closed'              not null,
    participants text                                                  not null,
    invitee      text                                                  not null,
    openedBy     mediumint(8)            default 0                     not null,
    openedDate   datetime                default '0000-00-00 00:00:00' not null
);

create table zt_im_conferenceaction
(
    id     mediumint unsigned auto_increment
        primary key,
    rid    char(24)                                            default ''                    not null,
    type   enum ('create', 'invite', 'join', 'leave', 'close') default 'create'              not null,
    user   mediumint(8)                                        default 0                     not null,
    date   datetime                                            default '0000-00-00 00:00:00' not null,
    device char(40)                                            default 'default'             not null
);

create table zt_im_message
(
    id          int(11) unsigned auto_increment
        primary key,
    gid         char(40)                                                             default ''                    not null,
    cgid        char(40)                                                             default ''                    not null,
    user        varchar(30)                                                          default ''                    not null,
    date        datetime                                                             default '0000-00-00 00:00:00' not null,
    type        enum ('normal', 'broadcast', 'notify', 'bulletin')                   default 'normal'              not null,
    content     text                                                                 default ''                    not null,
    contentType enum ('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') default 'text'                not null,
    data        text                                                                 default ''                    not null,
    deleted     enum ('0', '1')                                                      default '0'                   not null
);

create index mcgid
    on zt_im_message (cgid);

create index mgid
    on zt_im_message (gid);

create index mtype
    on zt_im_message (type);

create index muser
    on zt_im_message (user);

create table zt_im_message_backup
(
    id          int(11) unsigned                                                                                   not null,
    gid         char(40)                                                             default ''                    not null,
    cgid        char(40)                                                             default ''                    not null,
    user        varchar(30)                                                          default ''                    not null,
    date        datetime                                                             default '0000-00-00 00:00:00' not null,
    type        enum ('normal', 'broadcast', 'notify')                               default 'normal'              not null,
    content     text                                                                 default ''                    not null,
    contentType enum ('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') default 'text'                not null,
    data        text                                                                 default ''                    not null,
    deleted     enum ('0', '1')                                                      default '0'                   not null
);

create table zt_im_message_index
(
    id        mediumint unsigned auto_increment
        primary key,
    tableName char(64)                               not null,
    start     int(11) unsigned                       not null,
    end       int(11) unsigned                       not null,
    startDate datetime default '0000-00-00 00:00:00' not null,
    endDate   datetime default '0000-00-00 00:00:00' not null,
    chats     text                                   not null
);

create index end
    on zt_im_message_index (end);

create index endDate
    on zt_im_message_index (endDate);

create index start
    on zt_im_message_index (start);

create index startDate
    on zt_im_message_index (startDate);

create index tableName
    on zt_im_message_index (tableName);

create table zt_im_messagestatus
(
    user    mediumint(8)                                  default 0         not null,
    message int(11) unsigned                                                not null,
    status  enum ('waiting', 'sent', 'readed', 'deleted') default 'waiting' not null,
    constraint user
        unique (user, message)
);

create table zt_im_queue
(
    id          mediumint unsigned auto_increment
        primary key,
    type        char(30) not null,
    content     text     not null,
    addDate     datetime not null,
    processDate datetime not null,
    result      text     not null,
    status      char(30) not null
);

create table zt_im_userdevice
(
    id         mediumint unsigned auto_increment
        primary key,
    user       mediumint(8) default 0                     not null,
    device     char(40)     default 'default'             not null,
    deviceID   char(40)     default ''                    not null,
    token      char(64)     default ''                    not null,
    validUntil datetime     default '0000-00-00 00:00:00' not null,
    lastLogin  datetime     default '0000-00-00 00:00:00' not null,
    lastLogout datetime     default '0000-00-00 00:00:00' not null,
    constraint userdevice
        unique (user, device)
);

create index lastLogin
    on zt_im_userdevice (lastLogin);

create index lastLogout
    on zt_im_userdevice (lastLogout);

create index user
    on zt_im_userdevice (user);

create table zt_job
(
    id          mediumint unsigned auto_increment
        primary key,
    name        varchar(50)                 not null,
    repo        mediumint unsigned          not null,
    product     mediumint unsigned          not null,
    frame       varchar(20)                 not null,
    engine      varchar(20)                 not null,
    server      mediumint unsigned          not null,
    pipeline    varchar(500)                not null,
    triggerType varchar(255)                not null,
    svnDir      varchar(255)                not null,
    atDay       varchar(255)                null,
    atTime      varchar(10)                 null,
    customParam text                        not null,
    comment     varchar(255)                null,
    createdBy   varchar(30)                 not null,
    createdDate datetime                    not null,
    editedBy    varchar(30)                 not null,
    editedDate  datetime                    not null,
    lastExec    datetime                    null,
    lastStatus  varchar(255)                null,
    lastTag     varchar(255)                null,
    deleted     enum ('0', '1') default '0' not null
);

create table zt_lang
(
    id       mediumint unsigned auto_increment
        primary key,
    lang     varchar(30)                 not null,
    module   varchar(30)                 not null,
    section  varchar(30)                 not null,
    `key`    varchar(60)                 not null,
    value    text                        not null,
    `system` enum ('0', '1') default '1' not null,
    constraint lang
        unique (lang, module, section, `key`)
);

create table zt_log
(
    id          mediumint unsigned auto_increment
        primary key,
    objectType  varchar(30)        not null,
    objectID    mediumint unsigned not null,
    action      mediumint unsigned not null,
    date        datetime           not null,
    url         varchar(255)       not null,
    contentType varchar(30)        not null,
    data        text               not null,
    result      text               not null
);

create index obejctID
    on zt_log (objectID);

create index objectType
    on zt_log (objectType);

create table zt_module
(
    id        mediumint unsigned auto_increment
        primary key,
    root      mediumint unsigned   default 0   not null,
    branch    mediumint unsigned   default 0   not null,
    name      char(60)             default ''  not null,
    parent    mediumint unsigned   default 0   not null,
    path      char(255)            default ''  not null,
    grade     tinyint unsigned     default 0   not null,
    `order`   smallint(5) unsigned default 0   not null,
    type      char(30)                         not null,
    owner     varchar(30)                      not null,
    collector text                             not null,
    short     varchar(30)                      not null,
    deleted   enum ('0', '1')      default '0' not null
);

create index path
    on zt_module (path);

create index root
    on zt_module (root);

create index type
    on zt_module (type);

create table zt_mr
(
    id            mediumint unsigned auto_increment
        primary key,
    gitlabID      mediumint unsigned          not null,
    sourceProject int unsigned                not null,
    sourceBranch  varchar(100)                not null,
    targetProject int unsigned                not null,
    targetBranch  varchar(100)                not null,
    mriid         int unsigned                not null,
    title         varchar(255)                not null,
    description   text                        not null,
    assignee      varchar(255)                not null,
    reviewer      varchar(255)                not null,
    createdBy     varchar(30)                 not null,
    createdDate   datetime                    not null,
    editedBy      varchar(30)                 not null,
    editedDate    datetime                    not null,
    deleted       enum ('0', '1') default '0' not null,
    status        char(30)                    not null,
    mergeStatus   char(30)                    not null
);

create table zt_notify
(
    id          mediumint unsigned auto_increment
        primary key,
    objectType  varchar(50)                not null,
    objectID    mediumint unsigned         not null,
    action      mediumint                  not null,
    toList      varchar(255)               not null,
    ccList      text                       not null,
    subject     varchar(255)               not null,
    data        text                       not null,
    createdBy   char(30)                   not null,
    createdDate datetime                   not null,
    sendTime    datetime                   not null,
    status      varchar(10) default 'wait' not null,
    failReason  text                       not null
);

create index objectType_toList_status
    on zt_notify (objectType, toList, status);

create table zt_oauth
(
    account      varchar(30)        not null,
    openID       varchar(255)       not null,
    providerType varchar(30)        not null,
    providerID   mediumint unsigned not null
);

create index account
    on zt_oauth (account);

create index providerID
    on zt_oauth (providerID);

create index providerType
    on zt_oauth (providerType);

create table zt_pipeline
(
    id          smallint(8) unsigned auto_increment
        primary key,
    type        char(30)                    not null,
    name        varchar(50)                 not null,
    url         varchar(255)                null,
    account     varchar(30)                 null,
    password    varchar(255)                not null,
    token       varchar(255)                null,
    private     char(32)                    null,
    createdBy   varchar(30)                 not null,
    createdDate datetime                    not null,
    editedBy    varchar(30)                 not null,
    editedDate  datetime                    not null,
    deleted     enum ('0', '1') default '0' not null
);

create table zt_planstory
(
    plan    mediumint unsigned not null,
    story   mediumint unsigned not null,
    `order` mediumint          not null,
    constraint plan_story
        unique (plan, story)
);

create table zt_product
(
    id             mediumint unsigned auto_increment
        primary key,
    program        mediumint unsigned                                  not null,
    name           varchar(90)                                         not null,
    code           varchar(45)                                         not null,
    bind           enum ('0', '1')                    default '0'      not null,
    line           mediumint(8)                                        not null,
    type           varchar(30)                        default 'normal' not null,
    status         varchar(30)                        default ''       not null,
    subStatus      varchar(30)                        default ''       not null,
    `desc`         text                                                not null,
    PO             varchar(30)                                         not null,
    QD             varchar(30)                                         not null,
    RD             varchar(30)                                         not null,
    acl            enum ('open', 'private', 'custom') default 'open'   not null,
    whitelist      text                                                not null,
    createdBy      varchar(30)                                         not null,
    createdDate    datetime                                            not null,
    createdVersion varchar(20)                                         not null,
    `order`        mediumint unsigned                                  not null,
    deleted        enum ('0', '1')                    default '0'      not null
);

create index acl
    on zt_product (acl);

create index `order`
    on zt_product (`order`);

create table zt_productplan
(
    id      mediumint unsigned auto_increment
        primary key,
    product mediumint unsigned          not null,
    branch  mediumint unsigned          not null,
    parent  mediumint       default 0   not null,
    title   varchar(90)                 not null,
    `desc`  text                        not null,
    begin   date                        not null,
    end     date                        not null,
    `order` text                        not null,
    deleted enum ('0', '1') default '0' not null
);

create index end
    on zt_productplan (end);

create index product
    on zt_productplan (product);

create table zt_project
(
    id             mediumint unsigned auto_increment
        primary key,
    project        mediumint(8)              default 0        not null,
    model          char(30)                                   not null,
    type           char(30)                  default 'sprint' not null,
    lifetime       char(30)                  default ''       not null,
    budget         varchar(30)               default '0'      not null,
    budgetUnit     char(30)                  default 'CNY'    not null,
    attribute      varchar(30)               default ''       not null,
    percent        float unsigned            default 0        not null,
    milestone      enum ('0', '1')           default '0'      not null,
    output         text                                       not null,
    auth           char(30)                                   not null,
    parent         mediumint unsigned        default 0        not null,
    path           varchar(255)                               not null,
    grade          tinyint unsigned                           not null,
    name           varchar(90)                                not null,
    code           varchar(45)                                not null,
    begin          date                                       not null,
    end            date                                       not null,
    realBegan      date                                       not null,
    realEnd        date                                       not null,
    days           smallint(5) unsigned                       not null,
    status         varchar(10)                                not null,
    subStatus      varchar(30)               default ''       not null,
    pri            enum ('1', '2', '3', '4') default '1'      not null,
    `desc`         text                                       not null,
    version        smallint(6)                                not null,
    parentVersion  smallint(6)                                not null,
    planDuration   int                                        not null,
    realDuration   int                                        not null,
    openedBy       varchar(30)               default ''       not null,
    openedDate     datetime                                   not null,
    openedVersion  varchar(20)                                not null,
    lastEditedBy   varchar(30)               default ''       not null,
    lastEditedDate datetime                                   not null,
    closedBy       varchar(30)               default ''       not null,
    closedDate     datetime                                   not null,
    canceledBy     varchar(30)               default ''       not null,
    canceledDate   datetime                                   not null,
    PO             varchar(30)               default ''       not null,
    PM             varchar(30)               default ''       not null,
    QD             varchar(30)               default ''       not null,
    RD             varchar(30)               default ''       not null,
    team           varchar(90)                                not null,
    acl            char(30)                  default 'open'   not null,
    whitelist      text                                       not null,
    `order`        mediumint unsigned                         not null,
    deleted        enum ('0', '1')           default '0'      not null
);

create index acl
    on zt_project (acl);

create index begin
    on zt_project (begin);

create index end
    on zt_project (end);

create index `order`
    on zt_project (`order`);

create index parent
    on zt_project (parent);

create index status
    on zt_project (status);

create table zt_projectcase
(
    project mediumint unsigned default 0 not null,
    product mediumint unsigned default 0 not null,
    `case`  mediumint unsigned default 0 not null,
    count   mediumint unsigned default 1 not null,
    version smallint(6)        default 1 not null,
    `order` smallint(6) unsigned         not null,
    constraint project
        unique (project, `case`)
);

create table zt_projectproduct
(
    project mediumint unsigned not null,
    product mediumint unsigned not null,
    branch  mediumint unsigned not null,
    plan    mediumint unsigned not null,
    primary key (project, product)
);

create table zt_projectspec
(
    project   mediumint(8)                not null,
    version   smallint(6)                 not null,
    name      varchar(255)                not null,
    milestone enum ('0', '1') default '0' not null,
    begin     date                        not null,
    end       date                        not null,
    constraint project
        unique (project, version)
);

create table zt_projectstory
(
    project mediumint unsigned default 0 not null,
    product mediumint unsigned           not null,
    story   mediumint unsigned default 0 not null,
    version smallint(6)        default 1 not null,
    `order` smallint(6) unsigned         not null,
    constraint project
        unique (project, story)
);

create table zt_relation
(
    id        int(8) auto_increment
        primary key,
    project   mediumint(8) not null,
    product   mediumint(8) not null,
    execution mediumint(8) not null,
    AType     char(30)     not null,
    AID       mediumint(8) not null,
    AVersion  char(30)     not null,
    relation  char(30)     not null,
    BType     char(30)     not null,
    BID       mediumint(8) not null,
    BVersion  char(30)     not null,
    extra     char(30)     not null,
    constraint relation
        unique (product, relation, AType, BType, AID, BID)
);

create table zt_release
(
    id        mediumint unsigned auto_increment
        primary key,
    project   mediumint unsigned                  not null,
    product   mediumint unsigned default 0        not null,
    branch    mediumint unsigned default 0        not null,
    build     mediumint unsigned                  not null,
    name      varchar(255)       default ''       not null,
    marker    enum ('0', '1')    default '0'      not null,
    date      date                                not null,
    stories   text                                not null,
    bugs      text                                not null,
    leftBugs  text                                not null,
    `desc`    text                                not null,
    mailto    text                                null,
    notify    varchar(255)                        null,
    status    varchar(20)        default 'normal' not null,
    subStatus varchar(30)        default ''       not null,
    deleted   enum ('0', '1')    default '0'      not null
);

create index build
    on zt_release (build);

create index product
    on zt_release (product);

create table zt_repo
(
    id       mediumint auto_increment
        primary key,
    product  varchar(255)                not null,
    name     varchar(255)                not null,
    path     varchar(255)                not null,
    prefix   varchar(100)                not null,
    encoding varchar(20)                 not null,
    SCM      varchar(10)                 not null,
    client   varchar(100)                not null,
    commits  mediumint unsigned          not null,
    account  varchar(30)                 not null,
    password varchar(30)                 not null,
    encrypt  varchar(30) default 'plain' not null,
    acl      text                        not null,
    synced   tinyint(1)  default 0       not null,
    lastSync datetime                    not null,
    `desc`   text                        not null,
    extra    char(30)                    not null,
    deleted  tinyint(1)                  not null
);

create table zt_repobranch
(
    repo     mediumint unsigned not null,
    revision mediumint unsigned not null,
    branch   varchar(255)       not null,
    constraint repo_revision_branch
        unique (repo, revision, branch)
);

create index branch
    on zt_repobranch (branch);

create index revision
    on zt_repobranch (revision);

create table zt_repofiles
(
    id       int unsigned auto_increment
        primary key,
    repo     mediumint unsigned not null,
    revision mediumint unsigned not null,
    path     varchar(255)       not null,
    parent   varchar(255)       not null,
    type     varchar(20)        not null,
    action   char               not null
);

create index parent
    on zt_repofiles (parent);

create index path
    on zt_repofiles (path);

create index repo
    on zt_repofiles (repo);

create index revision
    on zt_repofiles (revision);

create table zt_repohistory
(
    id        mediumint auto_increment
        primary key,
    repo      mediumint          not null,
    revision  varchar(40)        not null,
    commit    mediumint unsigned not null,
    comment   text               not null,
    committer varchar(100)       not null,
    time      datetime           not null
);

create index repo
    on zt_repohistory (repo);

create index revision
    on zt_repohistory (revision);

create table zt_score
(
    id       bigint(12) unsigned auto_increment
        primary key,
    account  varchar(30)             not null,
    module   varchar(30)  default '' not null,
    method   varchar(30)             not null,
    `desc`   varchar(250) default '' not null,
    `before` int          default 0  not null,
    score    int          default 0  not null,
    after    int          default 0  not null,
    time     datetime                not null
);

create index account
    on zt_score (account);

create index method
    on zt_score (method);

create index model
    on zt_score (module);

create table zt_searchdict
(
    `key` smallint(5) unsigned not null
        primary key,
    value char(3)              not null
);

create table zt_searchindex
(
    id         int unsigned auto_increment
        primary key,
    objectType char(20)  not null,
    objectID   mediumint not null,
    title      text      not null,
    content    text      not null,
    addedDate  datetime  not null,
    editedDate datetime  not null,
    constraint object
        unique (objectType, objectID)
);

create index addedDate
    on zt_searchindex (addedDate);

create fulltext index content
    on zt_searchindex (content);

create fulltext index title
    on zt_searchindex (title);

create table zt_stakeholder
(
    id          mediumint(8) auto_increment
        primary key,
    objectID    mediumint(8)    not null,
    objectType  char(30)        not null,
    user        char(30)        not null,
    type        char(30)        not null,
    `key`       enum ('0', '1') not null,
    `from`      char(30)        not null,
    createdBy   char(30)        not null,
    createdDate date            not null,
    editedBy    char(30)        not null,
    editedDate  date            not null,
    deleted     enum ('0', '1') not null
);

create table zt_story
(
    id             mediumint unsigned auto_increment
        primary key,
    parent         mediumint                                                                                                                   default 0                     not null,
    product        mediumint unsigned                                                                                                          default 0                     not null,
    branch         mediumint unsigned                                                                                                          default 0                     not null,
    module         mediumint unsigned                                                                                                          default 0                     not null,
    plan           text                                                                                                                                                      null,
    source         varchar(20)                                                                                                                                               not null,
    sourceNote     varchar(255)                                                                                                                                              not null,
    fromBug        mediumint unsigned                                                                                                          default 0                     not null,
    title          varchar(255)                                                                                                                                              not null,
    keywords       varchar(255)                                                                                                                                              not null,
    type           varchar(30)                                                                                                                 default 'story'               not null,
    category       varchar(30)                                                                                                                 default 'feature'             not null,
    pri            tinyint unsigned                                                                                                            default 3                     not null,
    estimate       float unsigned                                                                                                                                            not null,
    status         enum ('', 'changed', 'active', 'draft', 'closed')                                                                           default ''                    not null,
    subStatus      varchar(30)                                                                                                                 default ''                    not null,
    color          char(7)                                                                                                                                                   not null,
    stage          enum ('', 'wait', 'planned', 'projected', 'developing', 'developed', 'testing', 'tested', 'verified', 'released', 'closed') default 'wait'                not null,
    stagedBy       char(30)                                                                                                                                                  not null,
    mailto         text                                                                                                                                                      null,
    openedBy       varchar(30)                                                                                                                 default ''                    not null,
    openedDate     datetime                                                                                                                                                  not null,
    assignedTo     varchar(30)                                                                                                                 default ''                    not null,
    assignedDate   datetime                                                                                                                                                  not null,
    lastEditedBy   varchar(30)                                                                                                                 default ''                    not null,
    lastEditedDate datetime                                                                                                                                                  not null,
    reviewedBy     varchar(255)                                                                                                                                              not null,
    reviewedDate   datetime                                                                                                                    default '0000-00-00 00:00:00' not null,
    closedBy       varchar(30)                                                                                                                 default ''                    not null,
    closedDate     datetime                                                                                                                                                  not null,
    closedReason   varchar(30)                                                                                                                                               not null,
    toBug          mediumint unsigned                                                                                                                                        not null,
    childStories   varchar(255)                                                                                                                                              not null,
    linkStories    varchar(255)                                                                                                                                              not null,
    duplicateStory mediumint unsigned                                                                                                                                        not null,
    version        smallint(6)                                                                                                                 default 1                     not null,
    URChanged      enum ('0', '1')                                                                                                             default '0'                   not null,
    deleted        enum ('0', '1')                                                                                                             default '0'                   not null
);

create index assignedTo
    on zt_story (assignedTo);

create index product
    on zt_story (product);

create index status
    on zt_story (status);

create table zt_storyestimate
(
    story      mediumint   not null,
    round      smallint(6) not null,
    estimate   text        not null,
    average    float       not null,
    openedBy   varchar(30) not null,
    openedDate datetime    not null,
    constraint story
        unique (story, round)
);

create table zt_storyreview
(
    story      mediumint   not null,
    version    smallint(6) not null,
    reviewer   varchar(30) not null,
    result     varchar(30) not null,
    reviewDate datetime    not null,
    constraint story
        unique (story, version, reviewer)
);

create table zt_storyspec
(
    story   mediumint    not null,
    version smallint(6)  not null,
    title   varchar(255) not null,
    spec    text         not null,
    verify  text         not null,
    constraint story
        unique (story, version)
);

create table zt_storystage
(
    story    mediumint unsigned not null,
    branch   mediumint unsigned not null,
    stage    varchar(50)        not null,
    stagedBy char(30)           not null,
    constraint story_branch
        unique (story, branch)
);

create index story
    on zt_storystage (story);

create table zt_suitecase
(
    suite   mediumint unsigned   not null,
    product mediumint unsigned   not null,
    `case`  mediumint unsigned   not null,
    version smallint(5) unsigned not null,
    constraint suitecase
        unique (suite, `case`)
);

create table zt_task
(
    id             mediumint unsigned auto_increment
        primary key,
    project        mediumint unsigned                                                         not null,
    parent         mediumint(8)                                                default 0      not null,
    execution      mediumint unsigned                                          default 0      not null,
    module         mediumint unsigned                                          default 0      not null,
    design         mediumint unsigned                                                         not null,
    story          mediumint unsigned                                          default 0      not null,
    storyVersion   smallint(6)                                                 default 1      not null,
    designVersion  smallint(6) unsigned                                                       not null,
    fromBug        mediumint unsigned                                          default 0      not null,
    name           varchar(255)                                                               not null,
    type           varchar(20)                                                                not null,
    pri            tinyint unsigned                                            default 0      not null,
    estimate       float unsigned                                                             not null,
    consumed       float unsigned                                                             not null,
    `left`         float unsigned                                                             not null,
    deadline       date                                                                       not null,
    status         enum ('wait', 'doing', 'done', 'pause', 'cancel', 'closed') default 'wait' not null,
    subStatus      varchar(30)                                                 default ''     not null,
    color          char(7)                                                                    not null,
    mailto         text                                                                       null,
    `desc`         text                                                                       not null,
    version        smallint(6)                                                                not null,
    openedBy       varchar(30)                                                                not null,
    openedDate     datetime                                                                   not null,
    assignedTo     varchar(30)                                                                not null,
    assignedDate   datetime                                                                   not null,
    estStarted     date                                                                       not null,
    realStarted    datetime                                                                   not null,
    finishedBy     varchar(30)                                                                not null,
    finishedDate   datetime                                                                   not null,
    finishedList   text                                                                       not null,
    canceledBy     varchar(30)                                                                not null,
    canceledDate   datetime                                                                   not null,
    closedBy       varchar(30)                                                                not null,
    closedDate     datetime                                                                   not null,
    planDuration   int                                                                        not null,
    realDuration   int                                                                        not null,
    closedReason   varchar(30)                                                                not null,
    lastEditedBy   varchar(30)                                                                not null,
    lastEditedDate datetime                                                                   not null,
    activatedDate  date                                                                       not null,
    deleted        enum ('0', '1')                                             default '0'    not null
);

create index assignedTo
    on zt_task (assignedTo);

create index execution
    on zt_task (execution);

create index parent
    on zt_task (parent);

create index story
    on zt_task (story);

create table zt_taskestimate
(
    id       mediumint unsigned auto_increment
        primary key,
    task     mediumint unsigned default 0  not null,
    date     date                          not null,
    `left`   float unsigned     default 0  not null,
    consumed float unsigned                not null,
    account  char(30)           default '' not null,
    work     text                          null
);

create index task
    on zt_taskestimate (task);

create table zt_taskspec
(
    task       mediumint(8) not null,
    version    smallint(6)  not null,
    name       varchar(255) not null,
    estStarted date         not null,
    deadline   date         not null,
    constraint task
        unique (task, version)
);

create table zt_team
(
    id       mediumint unsigned auto_increment
        primary key,
    root     mediumint unsigned                    default 0            not null,
    type     enum ('project', 'task', 'execution') default 'project'    not null,
    account  char(30)                              default ''           not null,
    role     char(30)                              default ''           not null,
    limited  char(8)                               default 'no'         not null,
    `join`   date                                  default '0000-00-00' not null,
    days     smallint(5) unsigned                                       not null,
    hours    float(3, 1) unsigned                  default 0.0          not null,
    estimate decimal(12, 2) unsigned               default 0.00         not null,
    consumed decimal(12, 2) unsigned               default 0.00         not null,
    `left`   decimal(12, 2) unsigned               default 0.00         not null,
    `order`  tinyint(3)                            default 0            not null,
    constraint team
        unique (root, type, account)
);

create table zt_testreport
(
    id          mediumint unsigned auto_increment
        primary key,
    project     mediumint unsigned not null,
    product     mediumint unsigned not null,
    execution   mediumint unsigned not null,
    tasks       varchar(255)       not null,
    builds      varchar(255)       not null,
    title       varchar(255)       not null,
    begin       date               not null,
    end         date               not null,
    owner       char(30)           not null,
    members     text               not null,
    stories     text               not null,
    bugs        text               not null,
    cases       text               not null,
    report      text               not null,
    objectType  varchar(20)        not null,
    objectID    mediumint unsigned not null,
    createdBy   char(30)           not null,
    createdDate datetime           not null,
    deleted     enum ('0', '1')    not null
);

create table zt_testresult
(
    id          mediumint unsigned auto_increment
        primary key,
    run         mediumint unsigned   not null,
    `case`      mediumint unsigned   not null,
    version     smallint(5) unsigned not null,
    job         mediumint unsigned   not null,
    compile     mediumint unsigned   not null,
    caseResult  char(30)             not null,
    stepResults text                 not null,
    lastRunner  varchar(30)          not null,
    date        datetime             not null,
    duration    float                not null,
    xml         text                 not null
);

create index `case`
    on zt_testresult (`case`);

create index run
    on zt_testresult (run);

create index version
    on zt_testresult (version);

create table zt_testrun
(
    id            mediumint unsigned auto_increment
        primary key,
    task          mediumint unsigned default 0  not null,
    `case`        mediumint unsigned default 0  not null,
    version       tinyint unsigned   default 0  not null,
    assignedTo    char(30)           default '' not null,
    lastRunner    varchar(30)                   not null,
    lastRunDate   datetime                      not null,
    lastRunResult char(30)                      not null,
    status        char(30)                      not null,
    constraint task
        unique (task, `case`)
);

create table zt_testsuite
(
    id             mediumint unsigned auto_increment
        primary key,
    project        mediumint unsigned not null,
    product        mediumint unsigned not null,
    name           varchar(255)       not null,
    `desc`         text               not null,
    type           varchar(20)        not null,
    addedBy        char(30)           not null,
    addedDate      datetime           not null,
    lastEditedBy   char(30)           not null,
    lastEditedDate datetime           not null,
    deleted        enum ('0', '1')    not null
);

create index product
    on zt_testsuite (product);

create table zt_testtask
(
    id               mediumint unsigned auto_increment
        primary key,
    project          mediumint unsigned                                       not null,
    product          mediumint unsigned                                       not null,
    name             char(90)                                                 not null,
    execution        mediumint unsigned                        default 0      not null,
    build            char(30)                                                 not null,
    type             varchar(255)                              default ''     not null,
    owner            varchar(30)                                              not null,
    pri              tinyint unsigned                          default 0      not null,
    begin            date                                                     not null,
    end              date                                                     not null,
    realFinishedDate datetime                                                 not null,
    mailto           text                                                     null,
    `desc`           text                                                     not null,
    report           text                                                     not null,
    status           enum ('blocked', 'doing', 'wait', 'done') default 'wait' not null,
    testreport       mediumint unsigned                                       not null,
    auto             varchar(10)                               default 'no'   not null,
    subStatus        varchar(30)                               default ''     not null,
    deleted          enum ('0', '1')                           default '0'    not null
);

create index build
    on zt_testtask (build);

create index product
    on zt_testtask (product);

create table zt_todo
(
    id           mediumint unsigned auto_increment
        primary key,
    account      char(30)                                                not null,
    date         date                                                    not null,
    begin        smallint unsigned zerofill                              not null,
    end          smallint unsigned zerofill                              not null,
    type         char(10)                                                not null,
    cycle        tinyint unsigned                         default 0      not null,
    idvalue      mediumint unsigned                       default 0      not null,
    pri          tinyint unsigned                                        not null,
    name         char(150)                                               not null,
    `desc`       text                                                    not null,
    status       enum ('wait', 'doing', 'done', 'closed') default 'wait' not null,
    private      tinyint(1)                                              not null,
    config       varchar(255)                                            not null,
    assignedTo   varchar(30)                              default ''     not null,
    assignedBy   varchar(30)                              default ''     not null,
    assignedDate datetime                                                not null,
    finishedBy   varchar(30)                              default ''     not null,
    finishedDate datetime                                                not null,
    closedBy     varchar(30)                              default ''     not null,
    closedDate   datetime                                                not null,
    deleted      enum ('0', '1')                          default '0'    not null
);

create index account
    on zt_todo (account);

create index assignedTo
    on zt_todo (assignedTo);

create index date
    on zt_todo (date);

create index finishedBy
    on zt_todo (finishedBy);

create table zt_user
(
    id           mediumint unsigned auto_increment
        primary key,
    company      mediumint unsigned                                                                  not null,
    type         char(30)                                              default 'inside'              not null,
    dept         mediumint unsigned                                    default 0                     not null,
    account      char(30)                                              default ''                    not null,
    password     char(32)                                              default ''                    not null,
    role         char(10)                                              default ''                    not null,
    realname     varchar(100)                                          default ''                    not null,
    pinyin       varchar(255)                                          default ''                    not null,
    nickname     char(60)                                              default ''                    not null,
    commiter     varchar(100)                                                                        not null,
    avatar       text                                                                                not null,
    birthday     date                                                  default '0000-00-00'          not null,
    gender       enum ('f', 'm')                                       default 'f'                   not null,
    email        char(90)                                              default ''                    not null,
    skype        char(90)                                              default ''                    not null,
    qq           char(20)                                              default ''                    not null,
    mobile       char(11)                                              default ''                    not null,
    phone        char(20)                                              default ''                    not null,
    weixin       varchar(90)                                           default ''                    not null,
    dingding     varchar(90)                                           default ''                    not null,
    slack        varchar(90)                                           default ''                    not null,
    whatsapp     varchar(90)                                           default ''                    not null,
    address      char(120)                                             default ''                    not null,
    zipcode      char(10)                                              default ''                    not null,
    nature       text                                                                                not null,
    analysis     text                                                                                not null,
    strategy     text                                                                                not null,
    `join`       date                                                  default '0000-00-00'          not null,
    visits       mediumint unsigned                                    default 0                     not null,
    ip           char(15)                                              default ''                    not null,
    last         int unsigned                                          default 0                     not null,
    fails        tinyint(5)                                            default 0                     not null,
    locked       datetime                                              default '0000-00-00 00:00:00' not null,
    ranzhi       char(30)                                              default ''                    not null,
    score        int                                                   default 0                     not null,
    scoreLevel   int                                                   default 0                     not null,
    deleted      enum ('0', '1')                                       default '0'                   not null,
    clientStatus enum ('online', 'away', 'busy', 'offline', 'meeting') default 'offline'             not null,
    clientLang   varchar(10)                                           default 'zh-cn'               not null,
    constraint account
        unique (account)
);

create index commiter
    on zt_user (commiter);

create index deleted
    on zt_user (deleted);

create index dept
    on zt_user (dept);

create index email
    on zt_user (email);

create table zt_usercontact
(
    id       mediumint unsigned auto_increment
        primary key,
    account  char(30)    not null,
    listName varchar(60) not null,
    userList text        not null
);

create index account
    on zt_usercontact (account);

create table zt_usergroup
(
    account char(30)           default '' not null,
    `group` mediumint unsigned default 0  not null,
    project text                          not null,
    constraint account
        unique (account, `group`)
);

create table zt_userquery
(
    id       mediumint unsigned auto_increment
        primary key,
    account  char(30)                    not null,
    module   varchar(30)                 not null,
    title    varchar(90)                 not null,
    form     text                        not null,
    `sql`    text                        not null,
    shortcut enum ('0', '1') default '0' not null
);

create index account
    on zt_userquery (account);

create index module
    on zt_userquery (module);

create table zt_usertpl
(
    id      mediumint unsigned auto_increment
        primary key,
    account char(30)                    not null,
    type    char(30)                    not null,
    title   varchar(150)                not null,
    content text                        not null,
    public  enum ('0', '1') default '0' not null
);

create index account
    on zt_usertpl (account);

create table zt_userview
(
    account  char(30)   not null,
    programs mediumtext not null,
    products mediumtext not null,
    projects mediumtext not null,
    sprints  mediumtext not null,
    constraint account
        unique (account)
);

create table zt_webhook
(
    id          mediumint unsigned auto_increment
        primary key,
    type        varchar(15)            default 'default'          not null,
    name        varchar(50)                                       not null,
    url         varchar(255)                                      not null,
    domain      varchar(255)                                      not null,
    secret      varchar(255)                                      not null,
    contentType varchar(30)            default 'application/json' not null,
    sendType    enum ('sync', 'async') default 'sync'             not null,
    products    text                                              not null,
    executions  text                                              not null,
    params      varchar(100)                                      not null,
    actions     text                                              not null,
    `desc`      text                                              not null,
    createdBy   varchar(30)                                       not null,
    createdDate datetime                                          not null,
    editedBy    varchar(30)                                       not null,
    editedDate  datetime                                          not null,
    deleted     enum ('0', '1')        default '0'                not null
);


