INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (1, 1, '1111', '', '1111', '', 'markdown', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (2, 2, '11111', '', '', '3', 'markdown', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (3, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省----->省）。
纵向配发:上级单位对下级单位进行装备的配发（如：省----->市     市-------->区）
配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
## 任务的状态:
| 任务状态 |             说明              |                         触发条件                         |          影响的数据          |  账单的数据   |
| :------: | :---------------------------: | :------------------------------------------------------: | :--------------------------: | :-----------: |
|          |                               |                         签字配发                         |                              |               |
|   302    |            配发中             |            出库房点击开始配发（入库方的待办）            | 装备的所属和所在不会发生改变 | 配发状态改为2 |
| 322/311  | 出库房待上传回执单(纵向/纵向) |                       出库房的待办                       |   装备的所在和所属发生改变   | 配发状态改为5 |
|   303    |      入库方待上传签收单       |               入库方点击入库(未上传签收单)               |             不变             |     不变      |
|   9999   |           任务办结            | 出库方和入库方任意一方签字入库并上传单据配发任务就结束了 |             不变             |     不变      |
|   333    |           配发草稿            |        点击配发，然后返回工作台，选择点击保存草稿        | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|          |                               |                         签章配发                         |                              |               |
|   333    |           配发草稿            |        点击配发，然后返回工作台，选择点击保存草稿        | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|   340    |        申请签章待审核         |                    选择签章人进行审核                    | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|   341    |        签章通过,待出库        |                      签章人审核通过                      |   装备的所在和所属发生改变   | 配发状态改为2 |
### 签字配发:
​		开始配发,选择配发单位决定配发的类型(横向配发，纵向配发)，点击签字配发，入库方和出库房都会有一个待办，如果出库方上传了回执单,则配发任务结束，如果出库方未上传回执单，进行了任务的撤回，则任务都结束，装备改为在库，如果出库方未做什么操作，出库方可以选择签字或者签章入库，如果选择了签字入库，入库方上传签收单入库，则任务结束。如果选择签章入库，则需要签章人进行审核。如果审核成功则任务结束，如果审核失败，则回到入库方接受配发装备。
### 签章配发:
​		开始配发,选择配发单位决定配发的类型(横向配发，纵向配发)，点击签章配发，签发人会有一个待办，签发人同意则入库方会有一个待办，入库方选择签章入库，需要签章人审核，审核成功则任务结束，审核失败需要重新选择入库方式，如果选择签字入库，则需要上传签收单入库来完结任务。
|               操作步骤               |     状态转换     |                         说明                          |
| :----------------------------------: | :--------------: | :---------------------------------------------------: |
|               保存草稿               |   null---->333   |               保存为操作，产生task待办                |
|               开始配发               | null/333--->302  |            从草稿开始配发或者直接发起配发             |
|              出库方待办              |     322/311      | 配发出库后，出库方产生一个上传回执单的待办(横向/纵向) |
|              入库方待办              |    302--->303    |            等待上传签收单(入库未上传单据)             |
| 出库方上传回执单或者收件方上传签收单 | 322/303---->9999 |                       任务办结                        |
|          出库方选择签章出库          |   null--->340    |                     等待签章审核                      |
|               审核通过               |    340--->341    |                     签章审核通过                      |
|                 撤回                 |   302--->20000   |                       任务撤回                        |
## 业务流程图：
![配发出库流程](http://192.168.100.247:8899/files/%E5%85%A5%E5%BA%93%E6%96%B9%E5%85%A5%E5%BA%93.png)
![配发回执流程](http://192.168.100.247:8899/files/%E5%87%BA%E5%BA%93%E6%96%B9%E9%85%8D%E5%8F%91%E5%85%A5%E5%BA%93.png)
![配发出库流程](http://192.168.100.247:8899/files//%E9%85%8D%E5%8F%91%E5%87%BA%E5%BA%93.png)
# 维修业务说明
## 流程概述：
​		A单位装备损坏，送给B单位进行维修，如果B单位可以维修好，则任务结束，否则B单位应继续向上送修。
区发起维修:
## 状态的说明:
```java 
/** * 维修送修状态 */
REPAIR_SEND_CONFIRM(700, "维修送修出库待审核"),
WAIT_RECEIVE(701, "等待接收维修装备"),
REPAIR_RECEIVE_CONFIRM(702, "接收维修装备待审核"),
REPAIRING(703, "维修中"),
WAIT_UPLOAD_FILE(704, "等待上传签收单"),
WAIT_UPLOAD_SEND_FILE(722, "等待上传回执单"),
COUNTRY_REPAIRING(777, "等待接收维修退回装备"),
REPAIR_SEND_DRAFT(788,"等待出库"),
REPAIR_SEND_SIGN_WAIT_CONFIRM(790,"申请签章待审核"),
REPAIR_SEND_WAIT_SIGN(791,"等待盖章"),
 /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");  /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");
```
### 状态的转换说明:
|                    操作步骤                    |       状态的转换        |                     说明                     |
| :--------------------------------------------: | :---------------------: | :------------------------------------------: |
|               开始维修(签字出库)               | null--->722,null--->701 | 出库方等待上传回执单/入库方等待接收维修装备  |
|              出库方选择上传回执单              |       722--->9999       |           出库方和入库方的任务办结           |
|        入库方选择签字入库未(上传签收单)        |       701--->704        |                等待上传签收单                |
|                入库方上传签收单                |      704---->9999       |           出库方和入库方的任务办结           |
|               开始维修(签章出库)               |       null--->790       |                 等待签章审核                 |
|                    同意盖章                    |       790---->791       |                 签章审核成功                 |
|                    拒绝盖章                    |       790--->788        |                   等待出库                   |
|       区--->点击维修---->区的待维修管理        |            9            |                   等待送修                   |
|           区---->发起维修(市未入库)            |         9--->0          |             等待送修--->等待维修             |
|                     市入库                     |         0--->1          |              等待维修--->送修中              |
| 市发起维修(区送修)--->额外产生一个新的维修详情 |    源:1---->8  新:0     | 源:送修中--->等待上级装备退回    旧:等待维修 |
|                     省入库                     |         0--->1          |              等待维修--->送修中              |
|       市--->点击维修---->市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//%E7%BB%B4%E4%BF%AE.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//%E8%87%AA%E6%9F%A5%E6%B5%81%E7%A8%8B.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//%E6%A0%B8%E6%9F%A5%E6%B5%81%E7%A8%8B.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//%E5%B8%82%E5%AF%B9%E5%8C%BA%E6%A3%80%E6%9F%A5%E5%9B%BE.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//%E5%8C%BA%E8%87%AA%E6%9F%A5%E6%B5%81%E7%A8%8B.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                               |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                             |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                           | 核查结果   |
| ---------------------------------- | ---------- |
| 在完成以前的状态                   | 无         |
| 完成状态                           | 等待省审核 |
| 完成且省审核通过                   | 无误       |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//%E5%B8%82%E8%87%AA%E6%9F%A5%E6%B5%81%E7%A8%8B.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 结果   |
| ----------------- | ------ |
| 等待市专管员A处理 | 无     |
| 等待市专管员B处理 | 进行中 |
| 完结              | 完成   |
**核查结果**
| 核查情况                           | 核查结果   |
| ---------------------------------- | ---------- |
| 在完成以前的状态                   | 无         |
| 完成状态                           | 等待省审核 |
| 完成且省审核通过                   | 无误       |
| 完成且省审核未通过(点击回退按钮了) | 未通过     |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
  并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
  否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                                 |
| -------- | ---------------------------------------- |
| 无       | 该市级下所有区的核查结果为无             |
| 待省审核 | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过   |
| 无误     | 该市级下所有区的核查结果都为无误         |
| 审核中   | 其他情况下为审核中                       |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## ', '', 'markdown', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (4, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                               |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                             |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                           | 核查结果   |
| ---------------------------------- | ---------- |
| 在完成以前的状态                   | 无         |
| 完成状态                           | 等待省审核 |
| 完成且省审核通过                   | 无误       |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 结果   |
| ----------------- | ------ |
| 等待市专管员A处理 | 无     |
| 等待市专管员B处理 | 进行中 |
| 完结              | 完成   |
**核查结果**
| 核查情况                           | 核查结果   |
| ---------------------------------- | ---------- |
| 在完成以前的状态                   | 无         |
| 完成状态                           | 等待省审核 |
| 完成且省审核通过                   | 无误       |
| 完成且省审核未通过(点击回退按钮了) | 未通过     |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
  并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
  否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                                 |
| -------- | ---------------------------------------- |
| 无       | 该市级下所有区的核查结果为无             |
| 待省审核 | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过   |
| 无误     | 该市级下所有区的核查结果都为无误         |
| 审核中   | 其他情况下为审核中                       |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## ', '', 'markdown', 2);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (5, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                               |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                             |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                           | 核查结果   |
| ---------------------------------- | ---------- |
| 在完成以前的状态                   | 无         |
| 完成状态                           | 等待省审核 |
| 完成且省审核通过                   | 无误       |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 结果   |
| ----------------- | ------ |
| 等待市专管员A处理 | 无     |
| 等待市专管员B处理 | 进行中 |
| 完结              | 完成   |
**核查结果**
| 核查情况                           | 核查结果   |
| ---------------------------------- | ---------- |
| 在完成以前的状态                   | 无         |
| 完成状态                           | 等待省审核 |
| 完成且省审核通过                   | 无误       |
| 完成且省审核未通过(点击回退按钮了) | 未通过     |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
  并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
  否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                                 |
| -------- | ---------------------------------------- |
| 无       | 该市级下所有区的核查结果为无             |
| 待省审核 | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过   |
| 无误     | 该市级下所有区的核查结果都为无误         |
| 审核中   | 其他情况下为审核中                       |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
', '', 'markdown', 3);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (6, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 4);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (7, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 5);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (8, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
', '', 'markdown', 6);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (9, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 7);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (10, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发(如:省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 8);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (11, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 9);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (12, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 10);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (13, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：省-----&gt;区
配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 11);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (14, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：`省-----&gt;区`）
配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 12);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (15, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：`省-&gt;区`）
配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 13);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (16, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：`省到省`）。
纵向配发:上级单位对下级单位进行装备的配发（如：`省到市以及市到区`）
配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
## 性能优化与监控
', '', 'markdown', 14);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (17, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
横向配发:同级单位进行配发（如：`省到省`）。
纵向配发:上级单位对下级单位进行装备的配发（如：`省到市` `市到区`）
配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
## 任务的状态:
| 任务状态 | 说明 |              触发条件                         |          影响的数据          |  账单的数据   |
| :------: | :---------------------------: | :------------------------------------------------------: | :--------------------------: | :-----------: |
|          |                               |                         签字配发                         |                              |               |
|   302    |            配发中             |            出库房点击开始配发（入库方的待办）            | 装备的所属和所在不会发生改变 | 配发状态改为2 |
| 322/311  | 出库房待上传回执单(纵向/纵向) |                       出库房的待办                       |   装备的所在和所属发生改变   | 配发状态改为5 |
|   303    |      入库方待上传签收单       |               入库方点击入库(未上传签收单)               |             不变             |     不变      |
|   9999   |           任务办结            | 出库方和入库方任意一方签字入库并上传单据配发任务就结束了 |             不变             |     不变      |
|   333    |           配发草稿            |        点击配发，然后返回工作台，选择点击保存草稿        | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|          |                               |                         签章配发                         |                              |               |
|   333    |           配发草稿            |        点击配发，然后返回工作台，选择点击保存草稿        | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|   340    |        申请签章待审核         |                    选择签章人进行审核                    | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|   341    |        签章通过,待出库        |                      签章人审核通过                      |   装备的所在和所属发生改变   | 配发状态改为2 |
### 签字配发:
​		开始配发,选择配发单位决定配发的类型(横向配发，纵向配发)，点击签字配发，入库方和出库房都会有一个待办，如果出库方上传了回执单,则配发任务结束，如果出库方未上传回执单，进行了任务的撤回，则任务都结束，装备改为在库，如果出库方未做什么操作，出库方可以选择签字或者签章入库，如果选择了签字入库，入库方上传签收单入库，则任务结束。如果选择签章入库，则需要签章人进行审核。如果审核成功则任务结束，如果审核失败，则回到入库方接受配发装备。
### 签章配发:
​		开始配发,选择配发单位决定配发的类型(横向配发，纵向配发)，点击签章配发，签发人会有一个待办，签发人同意则入库方会有一个待办，入库方选择签章入库，需要签章人审核，审核成功则任务结束，审核失败需要重新选择入库方式，如果选择签字入库，则需要上传签收单入库来完结任务。
|               操作步骤               |    状态转换    |                         说明                          |
| :----------------------------------: | :------------: | :---------------------------------------------------: |
|               保存草稿               |   null---333   |               保存为操作，产生task待办                |
|               开始配发               | null/333---302 |            从草稿开始配发或者直接发起配发             |
|              出库方待办              |    322/311     | 配发出库后，出库方产生一个上传回执单的待办(横向/纵向) |
|              入库方待办              |   302---303    |            等待上传签收单(入库未上传单据)             |
| 出库方上传回执单或者收件方上传签收单 | 322/303---9999 |                       任务办结                        |
|          出库方选择签章出库          |   null---340   |                     等待签章审核                      |
|               审核通过               |   340---341    |                     签章审核通过                      |
|                 撤回                 |  302---20000   |                       任务撤回                        |
## 业务流程图：
![配发出库流程](http://192.168.100.247:8899/files/入库方入库.png)
![配发回执流程](http://192.168.100.247:8899/files//出库方配发入库.png)
![配发出库流程](http://192.168.100.247:8899/files//配发出库.png)
# 维修业务说明
## 流程概述：
​		A单位装备损坏，送给B单位进行维修，如果B单位可以维修好，则任务结束，否则B单位应继续向上送修。
区发起维修:
## 状态的说明:
```java 
/** * 维修送修状态 */
REPAIR_SEND_CONFIRM(700, "维修送修出库待审核"),
WAIT_RECEIVE(701, "等待接收维修装备"),
REPAIR_RECEIVE_CONFIRM(702, "接收维修装备待审核"),
REPAIRING(703, "维修中"),
WAIT_UPLOAD_FILE(704, "等待上传签收单"),
WAIT_UPLOAD_SEND_FILE(722, "等待上传回执单"),
COUNTRY_REPAIRING(777, "等待接收维修退回装备"),
REPAIR_SEND_DRAFT(788,"等待出库"),
REPAIR_SEND_SIGN_WAIT_CONFIRM(790,"申请签章待审核"),
REPAIR_SEND_WAIT_SIGN(791,"等待盖章"),
 /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");  /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");
```
### 状态的转换说明:
|                    操作步骤                    |       状态的转换        |                     说明                     |
| :--------------------------------------------: | :---------------------: | :------------------------------------------: |
|               开始维修(签字出库)               | null---&gt;市的待维修管理        |            9            |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束', '', 'markdown', 15);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (18, 3, '配发、自查、维修、核查流程文档', '', '# 配发业务说明
## 流程概述:
A单位给B单位送装备。只有市和省才有此权限。
## 配发的类型:
### 横向配发，纵向配发
- 横向配发:同级单位进行配发（如：`省到省`）。
- 纵向配发:上级单位对下级单位进行装备的配发（如：`省到市` `市到区`）配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
- 配发的状态(allotStatus)：0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成
## 任务的状态:
| 任务状态 | 说明 |              触发条件                         |          影响的数据          |  账单的数据   |
| :------: | :---------------------------: | :------------------------------------------------------: | :--------------------------: | :-----------: |
|          |                               |                         签字配发                         |                              |               |
|   302    |            配发中             |            出库房点击开始配发（入库方的待办）            | 装备的所属和所在不会发生改变 | 配发状态改为2 |
| 322/311  | 出库房待上传回执单(纵向/纵向) |                       出库房的待办                       |   装备的所在和所属发生改变   | 配发状态改为5 |
|   303    |      入库方待上传签收单       |               入库方点击入库(未上传签收单)               |             不变             |     不变      |
|   9999   |           任务办结            | 出库方和入库方任意一方签字入库并上传单据配发任务就结束了 |             不变             |     不变      |
|   333    |           配发草稿            |        点击配发，然后返回工作台，选择点击保存草稿        | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|          |                               |                         签章配发                         |                              |               |
|   333    |           配发草稿            |        点击配发，然后返回工作台，选择点击保存草稿        | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|   340    |        申请签章待审核         |                    选择签章人进行审核                    | 装备的所属和所在不会发生改变 | 配发状态改为0 |
|   341    |        签章通过,待出库        |                      签章人审核通过                      |   装备的所在和所属发生改变   | 配发状态改为2 |
### 签字配发:
​		开始配发,选择配发单位决定配发的类型(横向配发，纵向配发)，点击签字配发，入库方和出库房都会有一个待办，如果出库方上传了回执单,则配发任务结束，如果出库方未上传回执单，进行了任务的撤回，则任务都结束，装备改为在库，如果出库方未做什么操作，出库方可以选择签字或者签章入库，如果选择了签字入库，入库方上传签收单入库，则任务结束。如果选择签章入库，则需要签章人进行审核。如果审核成功则任务结束，如果审核失败，则回到入库方接受配发装备。
### 签章配发:
​		开始配发,选择配发单位决定配发的类型(横向配发，纵向配发)，点击签章配发，签发人会有一个待办，签发人同意则入库方会有一个待办，入库方选择签章入库，需要签章人审核，审核成功则任务结束，审核失败需要重新选择入库方式，如果选择签字入库，则需要上传签收单入库来完结任务。
|               操作步骤               |    状态转换    |                         说明                          |
| :----------------------------------: | :------------: | :---------------------------------------------------: |
|               保存草稿               |    0---333     |               保存为操作，产生task待办                |
|               开始配发               |  0/333---302   |            从草稿开始配发或者直接发起配发             |
|              出库方待办              |    322/311     | 配发出库后，出库方产生一个上传回执单的待办(横向/纵向) |
|              入库方待办              |   302---303    |            等待上传签收单(入库未上传单据)             |
| 出库方上传回执单或者收件方上传签收单 | 322/303---9999 |                       任务办结                        |
|          出库方选择签章出库          |    0---340     |                     等待签章审核                      |
|               审核通过               |   340---341    |                     签章审核通过                      |
|                 撤回                 |  302---20000   |                       任务撤回                        |
## 业务流程图：
![配发出库流程](http://192.168.100.247:8899/files/入库方入库.png)
![配发回执流程](http://192.168.100.247:8899/files//出库方配发入库.png)
![配发出库流程](http://192.168.100.247:8899/files//配发出库.png)
# 维修业务说明
## 流程概述：
​		A单位装备损坏，送给B单位进行维修，如果B单位可以维修好，则任务结束，否则B单位应继续向上送修。
区发起维修:
## 状态的说明:
```java 
/** * 维修送修状态 */
REPAIR_SEND_CONFIRM(700, "维修送修出库待审核"),
WAIT_RECEIVE(701, "等待接收维修装备"),
REPAIR_RECEIVE_CONFIRM(702, "接收维修装备待审核"),
REPAIRING(703, "维修中"),
WAIT_UPLOAD_FILE(704, "等待上传签收单"),
WAIT_UPLOAD_SEND_FILE(722, "等待上传回执单"),
COUNTRY_REPAIRING(777, "等待接收维修退回装备"),
REPAIR_SEND_DRAFT(788,"等待出库"),
REPAIR_SEND_SIGN_WAIT_CONFIRM(790,"申请签章待审核"),
REPAIR_SEND_WAIT_SIGN(791,"等待盖章")
//维修设备内部状态列表
    /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");  /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");
```
### 状态的转换说明:
|                    操作步骤                    |    状态的转换     |                     说明                     |
| :--------------------------------------------: | :---------------: | :------------------------------------------: |
|               开始维修(签字出库)               | 0--- 722,0--- 701 | 出库方等待上传回执单/入库方等待接收维修装备  |
|              出库方选择上传回执单              |    722--- 9999    |           出库方和入库方的任务办结           |
|        入库方选择签字入库未(上传签收单)        |    701--- 704     |                等待上传签收单                |
|                入库方上传签收单                |   704---- 9999    |           出库方和入库方的任务办结           |
|               开始维修(签章出库)               |     0--- 790      |                 等待签章审核                 |
|                    同意盖章                    |    790---- 791    |                 签章审核成功                 |
|                    拒绝盖章                    |    790--- 788     |                   等待出库                   |
|       区--- 点击维修---- 区的待维修管理        |         9         |                   等待送修                   |
|            区----发起维修(市未入库)            |      9--- 0       |             等待送修--- 等待维修             |
|                     市入库                     |      0--- 1       |              等待维修--- 送修中              |
| 市发起维修(区送修)--- 额外产生一个新的维修详情 | 源:1---- 8  新:0  | 源:送修中--- 等待上级装备退回    旧:等待维修 |
|                     省入库                     |      0--- 1       |              等待维修--- 送修中              |
|        市--- 点击维修----市的待维修管理        |         9         |                   等待送修                   |
详细说明:
#### 维修完整操作步骤
1. 区在维修管理-待维修装备里选择装备进行送修（待维修装备列表中的装备由本级设备库将装备状态改为待维修的装备和接收的下级单位装备组成）
2. 市接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没有修好则继续进行送修操作（同步骤1）
3. 省接收装备后如果修好了，则在待维修列表中勾选修好的装备，点击维修完成，并在待领取装备列表中将该装备进行归还出库；如果没修好则向中机继续发起维修
4. 由于中机不参与本系统操作，在中机完成装备的维修并将装备归还给省后，由省在送修装备列表中选择该装备进行入库操作
PS：
- 省向中机发起维修时需要上传 AB 岗签字的发送单（普通出库流程出库时不需要上传单据）
- 省在送修装备列表中选择该装备进行入库操作时，必须填写全部信息
- 装备在进行归还出库时，接受单位入库后该装备如果所属单位不是当前单位，则该装备会处于待领取装备列表中，接受单位需要继续进行归还出库的操作；如果所属单位是当前单位，则该装备的状态为在库
- 由于中机的回执单可能不会马上归还，省向中机发起维修后，不需要进行入库或上传回执单的操作，该装备的所在单位就变为中机；
- 所有的出入库都会产生装备的所在发生改变，以及装备的状态
## 流程图：
![维修](http://192.168.100.247:8899/files//维修.png)
# 自查业务说明
## 概述：
​		点击发起自查，生成一个上传自查的待办，上传了自查单，任务结束。
## 任务状态介绍:
```java
/** * 待自查 */
WAIT_SELF_CHECK(400, "待自查"),
/** * 待上传自查单 */
SELF_CHECK_CONFIRM(401, "待上传自查单"),
```
## 自查类型：
- 手动自查
- 终端自查
- 系统自查
  选择自查周期，系统定时会发起自查。
  点击手动自查，会生成一个等待上传自查单的待办。
  选择终端自查，也会生成等待自查单的待办。
  上传完自查单，任务就结束了，自查完成。
  ## 流程图：
![自查](http://192.168.100.247:8899/files//自查流程.png)
# 核查业务说明
## 流程说明
![核查流程](http://192.168.100.247:8899/files//核查流程.jpg)
## 涉及到的任务状态与术语说明
**任务状态号**
| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |
**术语**
| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |
## 市与区的检查页面
![市](http://192.168.100.247:8899/files//市对区检查图.jpg)
### 区自查流程
**任务流程**
![区自查流程](http://192.168.100.247:8899/files//区自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
2. 等待区专管员B处理 id = 121
3. 等待市专管员处理 id = 122
4. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |
### 市本级自查流程
![市本级自查](http://192.168.100.247:8899/files//市自查流程.jpg)
**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160
2. 等待市专管员B处理 id = 161
3. 完结 id = 9999
**核查情况**
如上图所示，核查情况与自查任务的状态有着对应的关系
| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |
**核查结果**
| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |
### 关于回退
市对区的回退
让当前任务本身回滚到重做的初始状态
- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
- 重置该自查详情里的各个装备的自查详情请看
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
省对区的回退
让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务
- 完结当前Task,发起新的Task，数据拷贝来源于当前Task
- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留
## 省对市的页面
![省对市核查图](images/confirmcheck/省对市核查图.jpg)
省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果
**核查情况**
此页面下的核查情况如下表所示
| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |
**核查结果**
此页面下的核查情况如下表所示
| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |
## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束
**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束
', '', 'markdown', 16);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (19, 4, '9.13-9.17 优化计划', '', '**本周需要完成所有流程的流程文档，并将其与之前的4个主流程文档合并**
', '', 'markdown', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (20, 4, '9.13-9.17 优化计划', '', '**本周需要完成所有流程的流程文档，并将其与之前的4个主流程文档合并**
**主要业务**
| 模块名 | 负责人      | 复杂度 | 文档进度 | 测试进度 |
| ------ | ----------- | ------ | -------- | -------- |
| 核查   | 张斌/李迪凡 | 高     | 完成     |          |
| 自查   | 张斌/周少攀 | 低     | 完成     |          |
| 配发   |             | 中     | 完成     |          |
| 维修   |             | 高     | 完成     |          |
**其他业务**
| 模块名   | 负责人      | 复杂度 | 文档进度 | 测试进度 |
| -------- | ----------- | ------ | -------- | -------- |
| 列装     |  |      |          |          |
| 入库     |  |        |          |          |
| 退回     |             |        |          |          |
| 销毁     |             |        |          |          |
| 退装     |             |        |          |          |
| 退役     |             |        |          |          |
| 报废     |             |        |          |          |
| 申请     |             |        |          |          |
| 丢失     |             |        |          |          |
| 找回     |             |        |          |          |
| 工作交接 |             |        |          |          |
| 培训     |             |        |          |          |
', '', 'markdown', 2);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (21, 4, '9.13-9.17 优化计划', '', '**本周以测试为主，流程核对暂置**
**主要业务**
| 模块名 | 负责人      | 复杂度 | 文档进度 | 测试进度 |
| ------ | ----------- | ------ | -------- | -------- |
| 核查   | 张斌/李迪凡 | 高     | 完成     |          |
| 自查   | 张斌/周少攀 | 低     | 完成     |          |
| 配发   |             | 中     | 完成     |          |
| 维修   |             | 高     | 完成     |          |
**其他业务**
| 模块名   | 负责人      | 复杂度 | 文档进度 | 测试进度 |
| -------- | ----------- | ------ | -------- | -------- |
| 列装     |  |      |          |          |
| 入库     |  |        |          |          |
| 退回     |             |        |          |          |
| 销毁     |             |        |          |          |
| 退装     |             |        |          |          |
| 退役     |             |        |          |          |
| 报废     |             |        |          |          |
| 申请     |             |        |          |          |
| 丢失     |             |        |          |          |
| 找回     |             |        |          |          |
| 工作交接 |             |        |          |          |
| 培训     |             |        |          |          |
', '', 'markdown', 3);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (22, 5, 'ZB管理持续跟进表20210927', '', '', '5', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (23, 6, 'ZB管理持续跟进表20211009', '', '', '6', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (24, 7, 'ZB管理持续跟进表20211014', '', '', '7', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (25, 8, 'ZB管理持续跟进表20211018', '', '', '8', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (26, 9, 'ZB管理持续跟进表20211020', '', '', '9', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (27, 10, 'ZB管理持续跟进表20211020（2）', '', '', '10', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (28, 11, 'ZB管理持续跟进表20211020', '', '', '11', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (29, 12, '1', '', '', '12', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (30, 12, '1', '', '', '', 'html', 2);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (31, 13, 'ZB管理持续跟进表20211025', '', '', '13', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (32, 14, 'ZB管理持续跟进表20211027', '', '', '15', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (33, 15, '禅道使用培训', '', '', '18', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (34, 16, '实验室项目质量管控准则', '', '', '19', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (35, 17, 'ZB管理持续跟进表20211109', '', '', '21', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (36, 18, 'ZB管理持续跟进表20211220', '', 'ZB管理持续跟进表20211220', '171', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (37, 19, '基本设计与计划', '', 'https://www.yuque.com/docs/share/72393af9-6e91-4c97-a97c-09b553811c43?# 《自动化测试平台》', '', 'markdown', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (38, 20, '基本设计与计划(草图)', '', 'https://www.yuque.com/docs/share/72393af9-6e91-4c97-a97c-09b553811c43?# 《自动化测试平台》', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (39, 21, '参考设计', '', 'https://tech.meituan.com/2018/01/09/lego-api-test.html', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (40, 22, 'Git仓库地址', '', 'https://git.yfzx.zjtys.com.cn/matrix/kt-keystone', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (41, 23, '概念设计', '', '<p><img src="{213.jpeg}" alt="" /></p>
<p><img src="{214.jpeg}" alt="" /></p>', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (42, 23, '概念设计', '', '<p><img src="{213.jpeg}" alt="" /></p>
<p><img src="{215.jpeg}" alt="" /></p>', '', 'html', 2);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (43, 24, 'BUG', '', '', '', 'markdown', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (44, 25, 'BUG', '', '<p>1. 环境页面&nbsp;</p>
<p>&nbsp; &nbsp; 点击第二条的编辑 -&gt; 取消 -&gt; 点击第一条的编辑 -&gt; 取消 -&gt; 出现以下效果<img src="{326.png}" alt="" /></p>', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (45, 24, 'BUG(废弃)', '', '', '', 'markdown', 2);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (46, 26, '开发周报', '', '', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (47, 26, '2022年6月6日 -&gt; 2022年6月10日 开发周报', '', '<p>黄夏豪&nbsp;</p>
<p>2022年6月6日&nbsp; 周一&nbsp; 在这个项目里做工作台和服务平台的Demo</p>
<p><span>2022年6月7日&nbsp; 周二&nbsp; 在这个项目里做工作台和服务平台的Demo</span></p>
<p>王威威</p>
<p><br /></p>
<p>江育林</p>
<p><br /></p>
<p>姚瑶</p>
<p><br /></p>
<p>谢潮</p>
<p><br /></p>
<p>杨波</p>', '', 'html', 2);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (48, 26, '2022年6月6日 -&gt; 2022年6月10日 开发周报', '', '<p>黄夏豪&nbsp;</p>
<p>2022年6月6日&nbsp; 周一&nbsp; 在这个项目里做工作台和服务平台的Demo</p>
<p><span>2022年6月7日&nbsp; 周二&nbsp; 在这个项目里做工作台和服务平台的Demo</span></p>
<p>王威威</p>
<p></p>
<p>江育林</p>
<p><br /></p>
<p>姚瑶</p>
<p><br /></p>
<p>谢潮</p>
<p><br /></p>
<p>杨波</p>', '', 'html', 3);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (49, 27, '周报', '', '<p>黄夏豪&nbsp;</p>
<p>2022年6月6日&nbsp; 周一&nbsp; 在这个项目里做工作台和服务平台的Demo</p>
<p>2022年6月7日&nbsp; 周二&nbsp; 在这个项目里做工作台和服务平台的Demo</p>
<p><br /></p>
<p>王威威</p>
<p><br /></p>
<p>江育林</p>
<p><br /></p>
<p><br /></p>
<p>姚瑶</p>
<p><br /></p>
<p>谢潮</p>
<p><br /></p>
<p>杨波</p>', '', 'html', 1);
INSERT INTO zentao.zt_doccontent (id, doc, title, digest, content, files, type, version) VALUES (50, 27, '2022年6月6日 -&gt; 2022年6月10日 周报', '', '<p>黄夏豪&nbsp;</p>
<p>2022年6月6日&nbsp; 周一&nbsp; 在这个项目里做工作台和服务平台的Demo</p>
<p>2022年6月7日&nbsp; 周二&nbsp; 在这个项目里做工作台和服务平台的Demo</p>
<p><br /></p>
<p>王威威</p>
<p><br /></p>
<p>江育林</p>
<p><br /></p>
<p><br /></p>
<p>姚瑶</p>
<p><br /></p>
<p>谢潮</p>
<p><br /></p>
<p>杨波</p>', '', 'html', 2);