# 会议智能管理系统自动测试总结

## 一. 测试汇总

### 1. 目前发现的问题

- 动态变量/环境变量/动作池变量/... 语法没有给清楚

- 后置动作无法跟前置动作关联(目前通过动参查询数据库最新生成的id)

- 执行器中自动生成的sql

  ```sql
  select * from kt_test_case c where c.project_id = 25  and c.des like '%' + '会议室库管理' + '%'
  ```

  正确的应该是

  ```sql
  select * from kt_test_case c where c.project_id = 25  and c.des like '%会议室库管理%'
  ```

- 如果执行过程中，自动测试项目本身报错，会导致报告无法生成

- 执行记录中，log日志出现了长度过长而报错的问题(将kt_execution_record表中的log类型改成了longtext)

- 使用中，测试添加接口时，出现过循环添加的情况，与添加前后置动作有关系。

- 目前返回值是图片无法实现

- 文件上传不能实现自动测试

- 当传入的body时达到longText时，程序无法运行

- 下面这种形式的json没解析出来

  实际需要的形式：

  ```json
  [
    {
      "cnName": "string",
      "processId": "string",
      "type": 0,
      "userId": "string"
    }
  ]
  ```

  目前解析出的形式：

  ```json
  {
  "userProcessVoList": 0
  }
  ```

- 执行器不能特别多的用例一起执行，错误信息：Data truncation: Data too long for column 'case_execute_vo_string' at row 1
- 测试中出现过，A表查B表中的数据

### 2. 可以优化

- 登录携带token，提取出来，统一使用或者可以批量添加，这样更方便。(动作中需要token)
- 尽量多一些默认选择，可以减少鼠标点击操作:

  - 大部分情况下都会直接用swagger中的快速创建接口，所以可以优化为，直接跳到快速添加，如果需要空白的，在选择空白

  - 执行器中，选择默认选择第一个环境，体验感会更佳
- 执行器，执行结束后，可以加入模糊查询(如果数据特别多的话，挨个找会很麻烦)。或者可以把错误的单独列出来
- 动作中的http请求需要随着环境的变化而变话会更好，或者http请求中，可以根据选择的环境，动态拼接ip+端口，或者做一个数据库的提示
- 进入接口测试之后，还是可以搜索接口，这样会方便很多。
- 执行器与调式中，详情页面信息显示不完整
- 行为动作中的Http请求同样加入读取swagger可以更舒服
- 执行过程中无用的信息过多
- 接口可以模仿swagger，做成分级的

### 3. 使用情况

- 文件上传的测试，会议室中需要输入账号密码，这种情况目前无法实现自动测试(日程相关接口:上传会议资料)
- 项目本身封装的返回值，可能出现都是成功，自动测试无法找到具体的判断条件（操作台-会后统计-两个饼接口）
- 获取当前会议的不过期二维码接口中，返回值是一张图片，自动测试项目无法返回图片（流相关）
- cha接口，一直是无权限，但是swagger可以查到(无报错)
- 执行器里，sql查询时，不知道需要查询的项目id时多少，这样会导致不知道sql语句如何写
- 执行器执行完成之前如果关闭了，提示不明显，作为用户，可能不知道现在是什么情况。不点开的话颜色提示的圆圈不会出现，只有接口失败时，外部有提示
- 生成的报告，要考虑到返回的内容中可能出现前端的标签，要进行处理，不然报告会乱套
- 用例结果集不清楚，还是需要打开swagger，查看结果集，才能准确找到例如token的位置(后端swagger解析中已经解析出了结果集)
- 报告中的结果信息不太容易理解
- 行为动作中多个动作不是很明确如何使用，比如：行为动作。接口中可以选择默认环境，登录可能在环境1中登录，也可能在环境2中登录。当一个行为有多个动作时，对应的环境，在接口中如何选择，则跑哪一个动作
- 如果被测试接口中的返回值，没有给出后置动作需要的数据，如：id，会出现问题
- 执行其中查询后，提示查询到了多少条测试用例
- 接口中加入，根据描述查询，url查询，更方便
- 有些数据可能在前端缓存中


### 4. 测试接口总结
- 会议智能管理系统总接口数141个，自动化测试可以覆盖的接口数量达到85%左右，目前，返回值如果是图片这种情况无法测试，文件上传可能会出现输入账号密码这种情况，目前无法测试。

#### ①无效的接口：

- area-require-controller：3个
- person-require-controller：3个
- standard-controller：3个
- template-controller：3个
- 与会人员管理中，根据id查询输入，分页查询页面列表：没有使用到的接口：2个
- 与会范围管理：5个
- 人员库相关API，更新同步浙政钉人员信息：1个
- 人员组织相关文档，更新单位信息：1个

#### ②不需要自动测试的接口：

- 与会人员管理中，更新信息（瑞成），根据姓名模糊查询人员库：2个
- 日程通知相关接口：3个
- 模拟发送：1个
- 瑞成相关接口文档：3个
- 配置管理，配置好了就不会改变了：3个
- 生成最初用户信息，生成一次就不使用了：1个

- 参会区域管理，新增：1个

#### ③暂时无法测试的接口

- 返回值是图片类的接口，目前无法测试
- 上传文件的接口， 无法实现自动测试
- 传入的数据量过大时，无法进行测试
