package org.matrix.actuators.variable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.matrix.entity.DynamicVariable;
import org.matrix.enums.DynamicVarType;
import org.springframework.beans.BeanUtils;

/**
 * DynamicVariableObj.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/7/4 at 17:35
 * Suffering is the most powerful teacher of life.
 */

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DynamicVariableObj对象", description = "变量执行器里使用的对象,封装了语法糖")
public class DynamicVariableObj extends DynamicVariable {


    @ApiModelProperty(hidden = true)
    @TableField(exist = false)
    private SqlExpDetail sqlExpDetail;

    public static DynamicVariableObj var2Obj(DynamicVariable variable) {
        DynamicVariableObj variableObj = new DynamicVariableObj();
        BeanUtils.copyProperties(variable, variableObj);
        variableObj.setSqlExpDetail(JSON.parseObject(variable.getDetail(), SqlExpDetail.class));
        return variableObj;
    }

}
