package org.matrix.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.matrix.local.service.impl.UserService;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

import java.time.LocalDateTime;

/**
 * MetaFieldHandler.
 * 元数据处理器，用于处理自动填充的字段
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/11/22 at 7:52 下午
 */
@Component
public class MetaFieldHandler implements MetaObjectHandler {


    /**
     * 创建时设置创建时间与创建用户id
     * @param metaObject 数据库原始对象
     */
    @Override
    public void insertFill(MetaObject metaObject) {
        // 插入创建时间 与 更新时间
        this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, LocalDateTime.now());
        this.strictInsertFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
        //插入创建用户 与 更新用户id
        Long loginUserId = UserService.findNowUserId();
        this.strictInsertFill(metaObject, "createUserId", Long.class, loginUserId);
        this.strictInsertFill(metaObject, "updateUserId", Long.class, loginUserId);
    }

    /**
     * 更新时设置更新时间与更新用户id
     * @param metaObject 数据库原始对象
     */
    @Override
    public void updateFill(MetaObject metaObject) {
        // 修改 更新时间
        this.strictUpdateFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
        // 修改 更新用户
        Long loginUserId = UserService.findNowUserId();
        this.strictUpdateFill(metaObject, "updateUserId", Long.class, loginUserId);
    }
}
