package org.matrix.config;

import org.matrix.socket.ExecutionSocketHandler;
import org.matrix.socket.ExecutionStatusMonitorSocketHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

/**
 * @author huangxiahao
 */
@Configuration
@EnableWebSocket
public class WebSocketConfig implements WebSocketConfigurer {

    private final ExecutionSocketHandler executionSocketHandler;

    private final ExecutionStatusMonitorSocketHandler executionStatusMonitorSocketHandler;

    public WebSocketConfig(ExecutionSocketHandler executionSocketHandler,ExecutionStatusMonitorSocketHandler executionStatusMonitorSocketHandler) {
        this.executionSocketHandler = executionSocketHandler;
        this.executionStatusMonitorSocketHandler = executionStatusMonitorSocketHandler;
    }

    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry
                .addHandler(executionSocketHandler, "ws")
                .addHandler(executionStatusMonitorSocketHandler, "statusMonitor")
                .setAllowedOrigins("*");
    }
}