package org.matrix.database.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.models.Swagger;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.service.IExecutionHistoryService;
import org.matrix.entity.ExecutionRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.groupingBy;

/**
 * TestController. 用于测试的控制器
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/21 at 4:53 PM
 * Suffering is the most powerful teacher of life.
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    CaseActuator caseActuator;

    @Autowired
    IExecutionHistoryService executionHistoryService;

    @SneakyThrows
    @GetMapping
    public void parseSwaggerTest(){
        OkHttpClient okHttpClient = new OkHttpClient();
        String testString = "{\"swagger\":\"2.0\",\"info\":{\"description\":\"自动测试系统接口文档\",\"version\":\"1.0\",\"title\":\"自动测试系统\"},\"host\":\"localhost:8765\",\"basePath\":\"/\"}";


        Request request = new Request.Builder().url("http://localhost:8765/v2/api-docs").build();
        try (Response response = okHttpClient.newCall(request).execute()) {
            okhttp3.ResponseBody body = response.body();
            String result = body.string();
            Swagger swagger = JSON.parseObject(testString, Swagger.class);
            if (response.isSuccessful()) {
                log.info("success:{}", body == null ? "" : result);
            } else {
                log.error("error,statusCode={},body={}", response.code(), body == null ? "" : body);
            }
        }

    }

    public String treeTest() {
        List<ExecutionRecord> recordList = new ArrayList<>();
        Map<Long, Map<Long, Map<Long, List<ExecutionRecord>>>> map = recordList.stream().collect(
                groupingBy(ExecutionRecord::getTestJobId,
                        groupingBy(ExecutionRecord::getTestCaseId,
                                groupingBy(ExecutionRecord::getTestDataId))));
        return "";
    }

    /**
     * 获得表名,用于测试http执行器的调用
     */
    @GetMapping("/tableName")
    public ResponseEntity<String> getTableName(@RequestParam String tableName) {
        return ResponseEntity.ok(tableName);
    }

    @PostMapping("/sendMessage")
    public ResponseEntity sendMessage(String tableName) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", String.format("你好: %s", tableName));
        return ResponseEntity.ok(jsonObject);
    }
}
