package org.matrix.testNg.xml.reportXml;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.actuators.checkpoint.CheckPointResult;

import java.util.List;

/**
 * 定义模板中需要的信息
 *
 * @author mruny
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DataBean {

    /**
     * 未执行的test数量
     */
    private int excludeTestsSize;

    /**
     * 测试通过的数量
     */
    private int passedTestsSize;

    /**
     * 测试失败的数量
     */
    private int failedTestsSize;

    /**
     * 测试跳过的数量
     */
    private int skippedTestsSize;

    /**
     * 全部执行的测试的数量
     */
    private int allTestsSize;

    /**
     * 测试耗时
     */
    private String testsTime;

    /**
     * 测试通过率
     */
    private String passPercent;

    /**
     * 单个测试时间
     */
    private String duration;

    /**
     * 测试用参数
     */
    private String params;

    /**
     * 测试描述
     */
    private String description;

    /**
     * Reporter Output
     */
    private List<String> output;

    /**
     * 测试依赖方法
     */
    private String dependMethod;

    /**
     * 测试异常原因
     */
    private Throwable throwable;

    /**
     * 异常堆栈信息
     */
    private StackTraceElement[] stackTrace;

    /**
     * 结果信息
     */
    private CheckPointResult resultMessage;

    /**
     * 用例名称
     */
    private String testCaseName;

    /**
     * 用例类型
     */
    private String type;

    /**
     * 详情参数
     */
    private String detail;

    /**
     * 前置行动ID组，例如：1，2，3
     */
    private String moveBefore;

    /**
     * 后置行动ID组，例如：1，2，3
     */
    private String moveAfterCase;

    /**
     * 测试执行后行动ID组，例如：1，2，3
     */
    private String moveAfterTest;

}