<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="./res/css/index.css">
    <link rel="stylesheet" href="./res/css/reset.css">
    <link rel="stylesheet" href="./res/css/bootstrap.css">
</head>

<body>
<div class="top">
    测试报告
</div>
<div class="content">
    <div class="topForm">
        <div class="topTitle">报告汇总</div>
        <form class="form">
            <#if overView ??>
                <div class="form-group flex">
                    <label for="total">总数:</label>
                    <input class="form-control" id="total" readonly="readonly" value="${overView.total!}"/>
                </div>
                <div class="form-group flex">
                    <label for="allTime">总耗时:</label>
                    <input class="form-control" id="allTime" readonly="readonly" value="${overView.allTime!}"/>
                </div>
                <div class="form-group flex">
                    <label for="passNum">通过数:</label>
                    <input class="form-control" id="passNum" readonly="readonly" value="${overView.passNum!}"/>
                </div>
                <div class="form-group flex">
                    <label for="failNum">失败数:</label>
                    <input class="form-control" id="failNum" readonly="readonly" value="${overView.failNum!}"/>
                </div>
                <div class="form-group flex">
                    <label for="probability">通过率:</label>
                    <input class="form-control" id="probability" readonly="readonly"
                           value="${overView.probability + "%"!}"/>
                </div>
            <#else>
            </#if>
        </form>
    </div>

    <div style="display: flex;">
        <div id="pieChart" style="width:50%;height: 350px;"></div>
        <div id="histogram" style="width:50%;height: 350px;"></div>
    </div>

    <div class="table" style="overflow: auto">
        <table class="table table-striped">
            <thead>
            <tr>
                <th>编号</th>
                <th>用例名称</th>
                <th>用例类型</th>
                <th>返回结果</th>
                <th>用例描述</th>
                <th>执行结果</th>
                <th>执行时间</th>
                <th>结果信息</th>
            </tr>
            </thead>
            <tbody>
            <#if fail ??>
                <#assign caseNo = 0>
                <#list fail as failCase>
                    <#if failCase.result?c == 'false'>
                        <tr>
                            <#assign caseNo=caseNo+1>
                            <th style="width: 60px" scope="row">
                                <div style="width: 60px">
                                    ${caseNo}
                                </div>
                            </th>
                            <td style="width: 184px">
                                <div style="width: 184px;">${failCase.testCaseName!}</div>
                            </td>
                            <td style="width: 108px">
                                <div style="width: 108px">
                                    ${failCase.type!}
                                </div>
                            </td>
                            <td style="width: 500px">
                                <div style="width: 500px;cursor: pointer;display: flex;justify-content: flex-start;align-items: flex-start"
                                     class="openJson">
                                    <img style="width: 16px;    margin-top: 4px;margin-right: 8px;transition:.5s all ease;user-select: none"
                                         src="./res/img/left.png"/>
                                    <span style="overflow: hidden; white-space: nowrap; text-overflow: ellipsis;font-size: 16px">{
                                ${failCase.detail!}
                                </span>
                                </div>
                            </td>
                            <td>
                                <div style="width: 160px">
                                    ${failCase.description!}
                                </div>
                            </td>
                            <td style="color: #a90000;width: 84px">
                                <div style="width: 84px">
                                    ${failCase.result?c}
                                </div>
                            </td>
                            <td style="width: 84px">
                                <div style="width: 84px">
                                    ${failCase.duration + "ms"!}
                                </div>
                            </td>
                            <td style="width: 84px"
                                class="clickClass"
                                data-message='${failCase.str?replace("\r\n", '')?replace("\'", "\\\"")!}'>
                                <div style="width: 84px">
                                    查看结果
                                </div>
                            </td>
                        </tr>
                    <#else>
                    </#if>
                </#list>
            <#else>
            </#if>
            </tbody>
            <tbody>
            <#if pass ??>
                <#assign caseNo = 0>
                <#list pass as passCase>
                    <#if passCase.result?c == 'true'>
                        <tr>
                            <#assign caseNo=caseNo+1>
                            <th style="width: 60px" scope="row">
                                <div style="width: 60px">
                                    ${caseNo}
                                </div>
                            </th>
                            <td style="width: 184px">
                                <div style="width: 184px;">${passCase.testCaseName!}</div>
                            </td>
                            <td style="width: 108px">
                                <div style="width: 108px">
                                    ${passCase.type!}
                                </div>
                            </td>
                            <td style="width: 500px">
                                <div style="width: 500px;cursor: pointer;display: flex;justify-content: flex-start;align-items: flex-start"
                                     class="openJson">
                                    <img style="width: 16px;    margin-top: 4px;margin-right: 8px;transition:.5s all ease;user-select: none"
                                         src="./res/img/left.png"/>
                                    <span style="overflow: hidden; white-space: nowrap; text-overflow: ellipsis;font-size: 16px">{
                                ${passCase.detail!}
                                </span>
                                </div>
                            </td>
                            <td>
                                <div style="width: 160px">
                                    ${passCase.description!}
                                </div>
                            </td>
                            <td style="color: green;width: 84px">
                                <div style="width: 84px">
                                    ${passCase.result?c}
                                </div>
                            </td>
                            <td style="width: 84px">
                                <div style="width: 84px">
                                    ${passCase.duration + "ms"!}
                                </div>
                            </td>
                            <td style="width: 84px"
                                class="clickClass"
                                data-message='${passCase.str!}'>
                                <div style="width: 84px">
                                    查看结果
                                </div>
                            </td>
                        </tr>
                    <#else>
                    </#if>
                </#list>
            <#else>
            </#if>
            </tbody>
        </table>
    </div>
</div>
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">结果信息</h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" id="grp">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">关闭</button>
            </div>
        </div>
    </div>
</div>
<script src="./res/js/jquery.min.js"></script>
<script src="./res/js/bootstrap.js"></script>
<script src="./res/js/echarts.min.js"></script>
<script>

    $(".clickClass").each((i, v) => {
        v.onclick = function () {
            if (!v.getAttribute('data-message')) {
                alert('该条测试数据执行失败')
                return
            }
            let data = JSON.parse(v.getAttribute('data-message')).checkPointResultDetails
            $('#myModal').modal()
            if (data) {
                let oDiv = document.getElementById('grp')
                $("#grp").empty();
                for (let item of data) {
                    let hr = document.createElement('hr')
                    oDiv.appendChild(hr)
                    for (let j in item) {
                        let div1 = document.createElement('div')
                        let lab1 = document.createElement('label')
                        let lab2 = document.createElement('label')
                        div1.className = 'form-group'
                        lab1.className = 'col-sm-4 control-label w20'
                        lab2.className = 'col-sm-6 control-label txtl'
                        let content = null
                        if (j == 'isSuccess') {
                            content = '是否成功:'
                        } else if (j == 'type') {
                            content = '类型:'
                        } else if (j == 'matchExpression') {
                            content = '匹配前表达式:'
                        } else if (j == 'parseExpression') {
                            content = '匹配后表达式:'
                        } else if (j == 'message') {
                            content = '信息:'
                        }
                        let message = null
                        if (item[j] == 'EXCEPTION_CHECK') {
                            message = '异常检查点'
                        } else if (item[j] == 'NULL_CHECK') {
                            message = '空值检查点'
                        } else if (item[j] == 'CONTAIN_CHECK') {
                            message = '包含检查点'
                        } else if (item[j] == 'NO_CONTAIN_CHECK') {
                            message = '不包含检查点'
                        } else if (item[j] == 'JSONPATH_CHECK') {
                            message = 'Jsonpath检查点'
                        } else {
                            message = item[j]
                        }
                        if (item[j] === true) {
                            lab2.style = 'color: green'
                        }
                        if (item[j] === false) {
                            lab2.style = 'color: #a90000'
                        }
                        lab1.innerText = content
                        lab2.innerText = message
                        div1.appendChild(lab1)
                        div1.appendChild(lab2)
                        oDiv.appendChild(div1)
                    }
                }
            }
        }
    })
    $('.openJson').each((i, v) => {
        v.onclick = function () {
            console.log(v.childNodes)
            if (v.childNodes[1].style.transform == 'rotate(90deg)') {
                v.childNodes[1].style.transform = 'rotate(0deg)'
            } else {
                v.childNodes[1].style.transform = 'rotate(90deg)'
            }
            if (v.childNodes[3].style.whiteSpace == 'pre') {
                v.childNodes[3].style.whiteSpace = 'nowrap'
                v.childNodes[3].style.overflow = 'hidden'
                v.childNodes[3].style.textOverflow = 'ellipsis'
            } else {
                v.childNodes[3].style.whiteSpace = 'pre'
            }

        }

    })
</script>
<script>
    let chartDom = document.getElementById('pieChart');
    let myChart = echarts.init(chartDom);
    let pieChart;

    pieChart = {
        title: {
            text: '测试通过率',
            subtext: '${overView.probability + "%"!}',
            left: 'center'
        },
        tooltip: {
            trigger: 'item'
        },
        legend: {
            top: '85%',
            left: 'center'
        },
        series: [
            {
                name: '是否通过',
                type: 'pie',
                radius: ['25%', '50%'],
                avoidLabelOverlap: false,
                itemStyle: {
                    borderRadius: 10,
                    borderColor: '#fff',
                    borderWidth: 2
                },
                label: {
                    show: false,
                    position: 'center'
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: '40',
                        fontWeight: 'bold'
                    },
                    labelLine: {
                        show: false,
                        fontSize: '40',
                        fontWeight: 'bold'
                    }
                },

                data: [
                    {
                        value: ${overView.passNum!}, name: 'pass', itemStyle: {
                            color: 'green'
                        }
                    },
                    {
                        value: ${overView.failNum!}, name: 'fail', itemStyle: {
                            color: '#a90000'
                        }
                    },
                ]
            }
        ]
    };

    let chartDom2 = document.getElementById('histogram');
    let myChart2 = echarts.init(chartDom2);
    let histogram;

    histogram = {
        xAxis: {
            type: 'category',
            data: ['pass', 'fail']
        },
        yAxis: {
            type: 'value'
        },
        series: [
            {
                data: [{
                    value: ${overView.passNum!},
                    itemStyle: {
                        color: 'green'
                    }
                }, {
                    value: ${overView.failNum!},
                    itemStyle: {
                        color: '#a90000'
                    }
                }],
                type: 'bar',
                showBackground: true,
                barWidth: 50,
                backgroundStyle: {
                    color: 'rgba(180, 180, 180, 0.2)'
                }
            }
        ]
    };

    myChart.setOption(pieChart);
    myChart2.setOption(histogram);
    window.onresize = function () {
        myChart.resize();
        myChart2.resize();
    }

</script>
</body>
</html>