package org.matrix.actuators.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.matrix.actuators.httpclient.*;
import org.matrix.entity.ExecutionRecord;
import org.matrix.service.IExecutionRecordService;
import org.matrix.exception.GlobalException;
import org.matrix.enums.TestExecuteType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.StringUtils;

import java.util.*;

import static java.util.stream.Collectors.groupingBy;

@RunWith(SpringRunner.class)
@SpringBootTest
class HttpClientActuatorTest {

    @Autowired
    HttpClientActuator httpClientActuator;

    @Autowired
    IExecutionRecordService executionRecordService;

    @Test
    void test(){
        JSONObject jsonObject = new JSONObject();
        JSONObject stringValue = new JSONObject();
        stringValue.put("account","hxh");
        stringValue.put("password","hxh1234567");
        jsonObject.put("url","http://127.0.0.1:8765/user/{id}");
        jsonObject.put("method","POST");
        jsonObject.put("requestType","JSON");
        jsonObject.put("stringValue",JSONObject.toJSON(stringValue));
        JSONArray array = new JSONArray();
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("requestType", HttpRequestType.PATH);
        jsonObject1.put("requestBodies", new RequestBody("id", MultiPartRequestBodyType.TEXT, "login"));
        array.add(jsonObject1);
        jsonObject.put("requestParams", array);


//        String json = "{\n" +
//                "    \"url\": \"\",\n" +
//                "    \"method\": \"POST\",\n" +
//                "    \"requestType\": \"JSON\",\n" +
//                "    \"stringValue\": \"{\n" +
//                "  \"account\": \"string\",\n" +
//                "  \"password\": \"string\"\n" +
//                "}\""+
//                "}";
         HttpRequestDetail httpRequestDetail1 = JSON.parseObject(JSONObject.toJSONString(jsonObject), HttpRequestDetail.class);
        HttpRequestDetail httpRequestDetail = JSON.parseObject(JSONObject.toJSONString(jsonObject), HttpRequestDetail.class);
        HttpResponseDetail httpResponseDetail = httpClientActuator.sendHttpRequest(httpRequestDetail,10l,1l);
        System.out.println(httpResponseDetail);
    }
    @Test
    void test2(){
        List<ExecutionRecord> results = getExecutionRecords(1L, null, null, "e9e0a9cd-df63-4fea-9992-68d31c8b2160", null);
        Map<Long, Map<Long, Map<Long, List<ExecutionRecord>>>> map = results.stream().collect(
                groupingBy(ExecutionRecord::getTestJobId,
                        groupingBy(ExecutionRecord::getTestCaseId,
                                groupingBy(ExecutionRecord::getTestDataId))));
        System.out.println("1");
    }

    List<ExecutionRecord> getExecutionRecords(Long userId, Long testDataId, Long testCaseId, String uniqueKey, TestExecuteType type) {
        List<ExecutionRecord> results = Optional.of(executionRecordService.list(
                Wrappers.lambdaQuery(ExecutionRecord.class)
                        .eq(userId != null, ExecutionRecord::getUserId, userId)
                        .eq(testDataId != null, ExecutionRecord::getTestDataId, testDataId)
                        .eq(testCaseId != null, ExecutionRecord::getTestCaseId, testCaseId)
                        .eq(StringUtils.hasLength(uniqueKey), ExecutionRecord::getUniqueKey, uniqueKey)
                        .eq(type != null, ExecutionRecord::getType, type)
        )).orElseThrow(() -> new GlobalException("xxx"));
        return results;
    }


    void putValueToNext(ExecutionRecord record, JSONObject resultJson, JSONArray jsonArray, int num){
        if (num==4){
            jsonArray.add(record.getLog());
        }else {
            if (num==1){
                JSONObject jsonObject = resultJson.getJSONObject(record.getTestJobId() + "");
                if (jsonObject!=null){
                    putValueToNext(record,jsonObject,jsonArray,2);
                }else {
                    JSONObject newJsonObject = new JSONObject();
                    resultJson.put(record.getTestJobId() + "",newJsonObject);
                    putValueToNext(record,newJsonObject,jsonArray,2);
                }
            }
            if (num==2){
                JSONObject jsonObject = resultJson.getJSONObject(record.getTestCaseId() + "");
                if (jsonObject!=null){
                    putValueToNext(record,jsonObject,jsonArray,3);
                }else {
                    JSONObject newJsonObject = new JSONObject();
                    resultJson.put(record.getTestCaseId() + "",newJsonObject);
                    putValueToNext(record,newJsonObject,jsonArray,3);
                }
            }
            if (num==3){
                JSONObject jsonObject = resultJson.getJSONObject(record.getTestDataId() + "");
                if (jsonObject!=null){
                    putValueToNext(record,jsonObject,jsonArray,4);
                }else {
                    JSONArray newJsonArray = new JSONArray();
                    resultJson.put(record.getTestDataId() + "",newJsonArray);
                    putValueToNext(record,null,jsonArray,4);
                }
            }
        }
    }


}
