package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.enums.ActionType;

/**
 * <p>
 * 动作
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Action对象", description = "动作")
@TableName(value = "kt_action")
public class Action extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("行为ID")
    private Long moveId;

    @ApiModelProperty("项目ID")
    private Long projectId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("类型 1为SQL，2为HTTP，3为CASE，4为WAIT_TIME")
    private ActionType type;
    
    @ApiModelProperty("详细参数")
    private String detail;

    @ApiModelProperty("环境参数id")
    private Long envId;

}
