package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.vo.TestCaseVo;
import org.springframework.beans.BeanUtils;

/**
 * <p>
 * 测试用例表，测试的平台的主体数据
 * </p>
 *
 * @author mry
 * @since 2022-07-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "test_case")
@ApiModel(value = "TestCase对象", description = "测试用例")
public class Case extends BaseEntity {

    /**
     * 名称
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称")
    private String name;

    /**
     * 接口文档id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("接口文档id")
    private Long docId;

    /**
     * 请求方式
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("请求方式")
    private String httpMethod;

    /**
     * 参数详情(包括参数值)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("参数详情(包括参数值)")
    private String parameters;

    /**
     * 前置动作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("前置动作id")
    private Long moveBefore;

    /**
     * 后置动作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("后置动作id")
    private Long moveAfter;

    /**
     * 项目id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("项目id")
    private Long projectId;

    public TestCaseVo toTestCaseVo() {
        TestCaseVo testCaseVo = new TestCaseVo();
        BeanUtils.copyProperties(this, testCaseVo);
        return testCaseVo;
    }
}
