package org.matrix.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.matrix.enums.DynamicVarType;

/**
 * <p>
 *
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DynamicVariable对象", description = "动参")
@TableName(value = "kt_dynamic_variable")
public class DynamicVariable extends BaseEntity {

    @ApiModelProperty("所属项目")
    private Long projectId;

    @ApiModelProperty("取用字段")
    private String takenField;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("动态变量类型 1为KV，2为SQL，3为CASE，4为HTTP")
    private DynamicVarType type;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("详细内容")
    private String detail;
}
