package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.enums.ExecutionHistoryStatus;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "")
@TableName(value = "kt_execution_history")
public class ExecutionHistory extends BaseEntity {

    private String uniqueKey;

    private Long caseId;

    private Long dataId;

    private Long jobId;

    private Long userId;

    private Long executionKey;

    private String url;

    private ExecutionHistoryStatus status = ExecutionHistoryStatus.READY;

    private String caseExecuteVoString;

    /**
     * 创建时间
     */
    @ApiModelProperty("开始执行时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private LocalDateTime startTime;

    /**
     * 更新时间
     */
    @ApiModelProperty("结束执行时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "Asia/Shanghai")
    private LocalDateTime endTime;




}
