package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.enums.SyncStatus;
import org.matrix.vo.InterfaceDocVo;
import org.springframework.beans.BeanUtils;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-07-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "kt_interface_doc")
@ApiModel(value = "InterfaceDoc对象", description = "接口文档")
public class InterfaceDoc extends BaseEntity {

    /**
     * 名称
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称")
    private String summary;

    /**
     * 说明
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("说明")
    private String des;

    /**
     * 请求方式
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("请求方式")
    private String httpMethod;

    /**
     * 接口相对路径
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("接口相对路径")
    private String pathUrl;

    /**
     * 参数详情(整段json)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("参数详情(整段json)")
    private String parameters;

    /**
     * 返回值信息(整段json)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("返回值信息(整段json)")
    private String responses;

    /**
     * 项目id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 环境id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("环境id")
    private Long envId;

    /**
     * 分组id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("分组id")
    private Long interfaceGroupId;

    /**
     * 同步状态
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("同步状态")
    private SyncStatus status;

    /**
     * 开发状态
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("开发状态")
    private String devStatus;

    /**
     * 负责人
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("负责人")
    private String dutyPeople;

    public InterfaceDocVo toInterfaceDocVo() {
        InterfaceDocVo interfaceDocVo = new InterfaceDocVo();
        BeanUtils.copyProperties(this, interfaceDocVo);
        return interfaceDocVo;
    }
}
