package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.vo.InterfaceGroupVo;
import org.springframework.beans.BeanUtils;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-07-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "kt_interface_grouping")
@ApiModel(value = "InterfaceGrouping对象", description = "接口分组")
public class InterfaceGrouping extends BaseEntity {

    /**
     * 名称（标签/分组(存在根目录)）
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称（标签/分组(存在根目录)）")
    private String tag;

    /**
     * 说明
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("说明")
    private String des;

    /**
     * 环境id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("环境id")
    private Long envId;

    /**
     * 项目id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 前置操作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("前置操作id")
    private Long moveBefore;

    /**
     * 后置操作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("后置操作id")
    private Long moveAfter;

    /**
     * 父类id(根目录默认为0)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("父类id(根目录默认为0)")
    private Long interfaceGroupingId;

    public InterfaceGroupVo toInterfaceGroupVo() {
        InterfaceGroupVo interfaceGroupVo = new InterfaceGroupVo();
        BeanUtils.copyProperties(this, interfaceGroupVo);
        return interfaceGroupVo;
    }

}
