package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.matrix.enums.SyncStatus;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-07-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "kt_mould_doc")
@ApiModel(value = "MouldDoc对象", description = "模型文档")
public class MouldDoc extends BaseEntity {

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 名称
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称")
    private String objName;

    /**
     * 分组id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("分组id")
    private Long mouldGroupingId;

    /**
     * 备注
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("备注")
    private String remarks;

    /**
     * 属性
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("属性")
    private String attributeOutVo;

    /**
     * 同步状态
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("同步状态")
    private SyncStatus status;

}
