package org.matrix.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 *
 * </p>
 *
 * @author mry
 * @since 2022-07-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "kt_mould_grouping")
@ApiModel(value = "MouldGrouping对象", description = "模型分组")
public class MouldGrouping extends BaseEntity {

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 名称
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称")
    private String name;

    /**
     * 父类id(默认为0)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("父类id(默认为0)")
    private Long mouldId;

}
