package org.matrix.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import lombok.AllArgsConstructor;

/**
 * ActionType.
 * 动作的类型，该变量决定了运行时使用哪一种执行器
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/2/25 at 5:18 PM
 * Suffering is the most powerful teacher of life.
 */
@AllArgsConstructor
public enum ActionType {

    /**
     * SQL类型动作,该动作执行SQL语句
     */
    SQL_ACTION(1, "SQL类型动作"),
    /**
     * HTTP类型动作,该动作执行HTTP接口
     */
    HTTP_ACTION(2, "HTTP类型动作"),
    /**
     * 用例类型动作,该动作执行另外的测试用例
     */
    CASE_ACTION(3, "用例类型动作"),
    /**
     * 等待类动作,线程休眠指定的秒数
     */
    WAIT_ACTION(4, "等待类动作");

    /**
     * 数据库里记录的字段使用该字段来记录
     */
    @EnumValue
    private final int code;

    private final String des;

    public int getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

}
