package org.matrix.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * MoveType.  行为的类型，对行为的目的进行一个分类
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/22 at 11:06 AM
 * Suffering is the most powerful teacher of life.
 */
@AllArgsConstructor
@Getter
public enum MoveType {

    /**
     * 登录类型的行为
     */
    OTHER(0, "其他类型"),

    /**
     * 登录类型的行为
     */
    LOGIN(1, "登录类型");

    @EnumValue
    @JsonValue
    private final int code;

    /**
     * 描述
     */
    private final String des;
}
