package org.matrix.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * swagger导入数据类型
 *
 * @author mruny
 * @create 2022/7/19 16:03:33
 */
@AllArgsConstructor
@Getter
public enum SwaggerDataType {

    /**
     * 接口/文档
     */
    INTERFACE_DOC(0, "接口/文档"),

    /**
     * 数据模型
     */
    MOULD_DOC(1, "数据模型"),

    /**
     * 环境
     */
    ENV(2,"环境"),

    /**
     * 测试用例
     */
    TEST_CAST(3,"测试用例"),

    /**
     * 测试套件
     */
    TEST_SUITE(4,"测试套件");

    @EnumValue
    @JsonValue
    private final int code;

    /**
     * 描述
     */
    private final String des;
}
