package org.matrix.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 同步状态
 *
 * @author mruny
 * @create 2022/7/20 17:12:20
 */
@AllArgsConstructor
@Getter
public enum SyncStatus {

    /**
     * 覆盖
     */
    UPDATE(0, "更新"),

    /**
     * 新增
     */
    INSERT(1, "新增"),

    /**
     * 复制
     */
    COPY(2, "同时存在"),

    /**
     * 未同步
     */
    NO(3, "未同步"),

    /**
     * 上次忽略的
     */
    IGNORE(4,"上次忽略的"),

    /**
     * 上次导入不存在
     */
    OTHER(4, "上次导入不存在");

    @EnumValue
    private final int code;

    /**
     * 描述
     */
    private final String des;
}
