package org.matrix.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.entity.Environment;
import org.matrix.vo.StatusCode;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
public interface IEnvironmentService extends IService<Environment> {

    /**
     * @param isDefault
     * @param wrappers
     */
    Boolean setIsDefaultByWrapper(Boolean isDefault, Wrapper wrappers);

    /**
     * swagger导入环境
     *
     * @param environment 环境对象
     * @return 导入结果
     */
    StatusCode importEnv(Environment environment);
}
