package org.matrix.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.entity.InterfaceDoc;
import org.matrix.vo.InterfaceVo;
import org.matrix.vo.StatusCode;

import java.util.List;

/**
 * @author mruny
 * @create 2022/7/18 11:26:10
 */
public interface IInterfaceDocService extends IService<InterfaceDoc> {
    /**
     * 导入接口文档
     *
     * @param interfaceVos 接口文档VO类
     * @param projectId    项目id
     * @param envId        环境id
     * @param pattern      导入方式(1:同url覆盖,2:同url同组覆盖,3:同url不同步,4:同url同组不同步,5:同时保留)
     * @param interfaceId  上级分组
     * @return 导入结果
     */
    StatusCode importInterfaceDoc(List<InterfaceVo> interfaceVos, Long projectId, Long envId, int pattern, Long interfaceId);

}
