package org.matrix.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.entity.MouldDoc;
import org.matrix.vo.MouldVo;
import org.matrix.vo.StatusCode;

import java.util.List;

/**
 * @author mruny
 * @create 2022/7/18 11:27:17
 */
public interface IMouldDocService extends IService<MouldDoc> {

    /**
     * 导入数据模型文档
     *
     * @param mouldDocs 数据模型文档对象集合Vo
     * @param projectId 项目id
     * @param pattern   导入方式(1:同名覆盖,2:同名同组覆盖,3:同名不同步,4:同名同组不同步,5:同时保留)
     * @param mouldId   上级分组
     * @return 导入结果
     */
    StatusCode importMouldDoc(List<MouldVo> mouldDocs, Long projectId, int pattern, Long mouldId);

}
