package org.matrix.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.entity.Case;
import org.matrix.entity.InterfaceDoc;
import org.matrix.entity.InterfaceGrouping;
import org.matrix.mapper.CaseMapper;
import org.matrix.mapper.InterfaceDocMapper;
import org.matrix.mapper.InterfaceGroupingMapper;
import org.matrix.service.ICaseService;
import org.matrix.vo.InterfaceDocVo;
import org.matrix.vo.InterfaceGroupVo;
import org.matrix.vo.TestCaseVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author mruny
 * @create 2022/7/18 11:29:39
 */
@Service
public class CaseServiceImpl extends ServiceImpl<CaseMapper, Case> implements ICaseService {

    @Autowired
    private InterfaceDocMapper interfaceDocMapper;

    @Autowired
    private InterfaceGroupingMapper interfaceGroupingMapper;

    @Autowired
    private CaseMapper caseMapper;

    /**
     * 查出所有分组以及分组下的接口和测试用例(树状结构)
     *
     * @param interfaceDocVosMap      所有接口文档，key : 接口文档分组id , value : 接口文档集合
     * @param interfaceGroupingVosMap 所有分组 key : 父分组id , value : 分组对象集合
     * @param testCaseVosMap          所有测试用例 key : 接口文档主键id , value : 测试用例集合
     * @param interfaceGroupVos       父级分组
     */
    public void getRecursiveGrouping(Map<Long, List<InterfaceDocVo>> interfaceDocVosMap,
                                     Map<Long, List<InterfaceGroupVo>> interfaceGroupingVosMap,
                                     Map<Long, List<TestCaseVo>> testCaseVosMap,
                                     List<InterfaceGroupVo> interfaceGroupVos) {
        if (interfaceGroupVos.size() != 0) {
            //根据父分组，查出所有的子分组
            for (InterfaceGroupVo interfaceGroupVo : interfaceGroupVos) {
                if (interfaceGroupVo.getId() != null) {
                    //父分组id
                    Long groupId = interfaceGroupVo.getId();
                    //分组下的分组
                    List<InterfaceGroupVo> interfaceGroupVoList = interfaceGroupingVosMap.get(groupId);
                    //分组下的接口
                    List<InterfaceDocVo> interfaceDocVoList = interfaceDocVosMap.get(groupId);
                    //找接口下的测试用例
                    if (interfaceDocVoList != null) {
                        for (InterfaceDocVo interfaceDocVo : interfaceDocVoList) {
                            if (interfaceDocVo.getId() != null) {
                                Long docId = interfaceDocVo.getId();
                                List<TestCaseVo> testCaseVos = testCaseVosMap.get(docId);
                                interfaceDocVo.setTestCaseVos(testCaseVos);
                            }
                        }
                    }
                    interfaceGroupVo.setInterfaceGroupVos(interfaceGroupVoList);
                    interfaceGroupVo.setInterfaceDocVos(interfaceDocVoList);
                    if (!CollectionUtils.isEmpty(interfaceGroupVoList)) {
                        getRecursiveGrouping(interfaceDocVosMap, interfaceGroupingVosMap, testCaseVosMap, interfaceGroupVoList);
                    }

                }
            }
        }
    }

    @Override
    public InterfaceGroupVo getAll(Long projectId) {
        InterfaceGroupVo groupVo = new InterfaceGroupVo();

        //分组
        List<InterfaceGroupVo> interfaceGroupVos = new ArrayList<>();
        List<InterfaceGrouping> interfaceGroupings = Optional.ofNullable(interfaceGroupingMapper.selectList(Wrappers.lambdaQuery(InterfaceGrouping.class)
                .eq(InterfaceGrouping::getProjectId, projectId))).orElse(new ArrayList<>());
        for (InterfaceGrouping interfaceGrouping : interfaceGroupings) {
            InterfaceGroupVo interfaceGroupVo = interfaceGrouping.toInterfaceGroupVo();
            interfaceGroupVos.add(interfaceGroupVo);
        }
        //key: 父分组id value : 接口分组集合
        Map<Long, List<InterfaceGroupVo>> interfaceGroupingVosMap = interfaceGroupVos.stream()
                .filter(interfaceGroupVo -> interfaceGroupVo != null && interfaceGroupVo.getInterfaceGroupingId() != null)
                .collect(Collectors.groupingBy(InterfaceGroupVo::getInterfaceGroupingId));
        //根目录下的所有分组
        List<InterfaceGroupVo> firstInterfaceVoGroupings = new ArrayList<>();
        if (interfaceGroupingVosMap.get(-1L) != null) {
            firstInterfaceVoGroupings = interfaceGroupingVosMap.get(-1L);
            groupVo.setInterfaceGroupVos(firstInterfaceVoGroupings);
        }


        //接口文档
        List<InterfaceDocVo> interfaceDocVos = new ArrayList<>();
        List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                .eq(InterfaceDoc::getProjectId, projectId))).orElse(new ArrayList<>());
        for (InterfaceDoc interfaceDoc : interfaceDocs) {
            InterfaceDocVo interfaceDocVo = interfaceDoc.toInterfaceDocVo();
            interfaceDocVos.add(interfaceDocVo);
        }
        //key : 接口分组主键id  value : 接口文档集合
        Map<Long, List<InterfaceDocVo>> interfaceDocVosMap = interfaceDocVos.stream()
                .filter(interfaceDocVo -> interfaceDocVo != null && interfaceDocVo.getInterfaceGroupId() != null)
                .collect(Collectors.groupingBy(InterfaceDocVo::getInterfaceGroupId));
        //根目录下的接口
        List<InterfaceDocVo> firstInterfaceDocVos = new ArrayList<>();
        if (interfaceDocVosMap.get(-1L) != null) {
            firstInterfaceDocVos = interfaceDocVosMap.get(-1L);
            groupVo.setInterfaceDocVos(firstInterfaceDocVos);
        }

        //所有测试用例
        List<TestCaseVo> testCaseVos = new ArrayList<>();
        List<Case> cases = Optional.ofNullable(caseMapper.selectList(Wrappers.lambdaQuery(Case.class)
                .eq(Case::getProjectId, projectId))).orElse(new ArrayList<>());
        for (Case aCase : cases) {
            TestCaseVo testCaseVo = aCase.toTestCaseVo();
            testCaseVos.add(testCaseVo);
        }
        //key : 接口文档id  value : 测试用例集合
        Map<Long, List<TestCaseVo>> testCaseVosMap = testCaseVos.stream()
                .filter(testCaseVo -> testCaseVo != null && testCaseVo.getDocId() != null)
                .collect(Collectors.groupingBy(TestCaseVo::getDocId));


        //外层接口下的测试用例
        for (InterfaceDocVo firstInterfaceDocVo : firstInterfaceDocVos) {
            if (firstInterfaceDocVo.getId() != null) {
                Long id = firstInterfaceDocVo.getId();
                //接口中所有的测试用例
                List<TestCaseVo> testCaseVoList = testCaseVosMap.get(id);
                firstInterfaceDocVo.setTestCaseVos(testCaseVoList);
            }
        }
        getRecursiveGrouping(interfaceDocVosMap, interfaceGroupingVosMap, testCaseVosMap, firstInterfaceVoGroupings);
        return groupVo;
    }


}
