package org.matrix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.entity.Environment;
import org.matrix.enums.SwaggerDataType;
import org.matrix.exception.GlobalException;
import org.matrix.mapper.EnvironmentMapper;
import org.matrix.service.IEnvironmentService;
import org.matrix.vo.StatusCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class EnvironmentServiceImpl extends ServiceImpl<EnvironmentMapper, Environment> implements IEnvironmentService {

    @Autowired
    private EnvironmentMapper environmentMapper;

    @Override
    public Boolean setIsDefaultByWrapper(Boolean isDefault, Wrapper wrappers) {
        Environment environment = new Environment();
        environment.setIsDefault(isDefault);
        return Optional.of(this
                .update(environment, wrappers)).get();
    }

    @Override
    public StatusCode importEnv(Environment environment) {
        int saveNum = 0;
        int updateNum = 0;
        int ignoreNum = 0;
        StatusCode statusCode = new StatusCode();
        statusCode.setSwaggerDataType(SwaggerDataType.ENV);
        if (environment != null && environment.getIp() != null) {
            List<Environment> environments = Optional.ofNullable(environmentMapper.selectList(Wrappers.lambdaQuery(Environment.class)
                    .eq(Environment::getProjectId, environment.getProjectId()))).orElse(new ArrayList<>());
            for (Environment env : environments) {
                if (environment.getIp().equals(env.getIp())) {
                    Integer integer = Optional.of(environmentMapper.updateById(environment)).orElseThrow(() -> new GlobalException("修改失败"));
                    updateNum = updateNum + integer;
                }
                break;
            }
            if (updateNum == 0) {
                Integer integer = Optional.of(environmentMapper.insert(environment)).orElseThrow(() -> new GlobalException("添加失败"));
                saveNum = saveNum + integer;
            }
        }
        statusCode.setSaveNum(saveNum);
        statusCode.setSaveNum(saveNum);
        statusCode.setUpdateNum(updateNum);
        statusCode.setIgnoreNum(ignoreNum);
        return statusCode;
    }
}
