package org.matrix.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.entity.ExecutionHistory;
import org.matrix.mapper.ExecutionHistoryMapper;
import org.matrix.service.IExecutionHistoryService;
import org.matrix.vo.ExecutionHistoryVo;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
@Service
public class ExecutionHistoryServiceImpl extends ServiceImpl<ExecutionHistoryMapper, ExecutionHistory> implements IExecutionHistoryService {

    @Override
    public IPage<ExecutionHistoryVo> pageExecutionHistoryVoByCaseIdAndJobId(Long caseId, Long jobId, String uniqueKey, int pageNum, int pageSize ) {
        // todo 黄夏豪 等待接入用户ID
        Page<ExecutionHistoryVo> page = new Page<>(pageNum, pageSize);
        return baseMapper.pageByCaseIdAndJobId(page,caseId,jobId,1L,uniqueKey);
    }

    @Override
    public ExecutionHistoryVo getLastExecutionHistory(Long caseId, Long jobId) {
        return baseMapper.selectLastExecutionHistoryVo(caseId,jobId,1L);
    }


}
