package org.matrix.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.datasource.IDataSourceService;
import org.matrix.entity.ExecutionRecord;
import org.matrix.enums.ExecutionRecType;
import org.matrix.exception.GlobalException;
import org.matrix.mapper.ExecutionRecordMapper;
import org.matrix.service.IExecutionRecordService;
import org.matrix.vo.TestExecuteLog;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author mry
 */
@Service
public class ExecutionRecordImpl extends ServiceImpl<ExecutionRecordMapper, ExecutionRecord> implements IExecutionRecordService {

    @Autowired
    IDataSourceService iDataSourceService;

    @Override
    public ExecutionRecord addExecutionRecord(TestExecuteLog testExecuteLog, String log) {
        ExecutionRecord executionRecord = new ExecutionRecord();
        BeanUtils.copyProperties(testExecuteLog,executionRecord);
        executionRecord.setLog(log);
        this.save(executionRecord);
        return executionRecord;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void setStatusByUniqueKey(String uniqueKey, ExecutionRecType status) {
        boolean emptyIfStr = StrUtil.isEmptyIfStr(uniqueKey);
        if (emptyIfStr){
            throw new GlobalException("不能根据空的unique修改执行状态");
        }else {
            ExecutionRecord executionRecord = new ExecutionRecord();
            update(executionRecord,Wrappers
                    .lambdaUpdate(ExecutionRecord.class)
                    .eq(ExecutionRecord::getUniqueKey,uniqueKey)
            );
        }
    }




}
