package org.matrix.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.entity.InterfaceDoc;
import org.matrix.entity.InterfaceGrouping;
import org.matrix.enums.SwaggerDataType;
import org.matrix.enums.SyncStatus;
import org.matrix.exception.GlobalException;
import org.matrix.mapper.InterfaceDocMapper;
import org.matrix.mapper.InterfaceGroupingMapper;
import org.matrix.service.IInterfaceDocService;
import org.matrix.vo.ImportInterfaceDoc;
import org.matrix.vo.InterfaceVo;
import org.matrix.vo.StatusCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author mruny
 * @create 2022/7/18 11:28:54
 */
@Service
public class InterfaceDocServiceImpl extends ServiceImpl<InterfaceDocMapper, InterfaceDoc> implements IInterfaceDocService {

    @Autowired
    private InterfaceDocMapper interfaceDocMapper;

    @Autowired
    private InterfaceGroupingMapper interfaceGroupingMapper;

    @Override
    public StatusCode importInterfaceDoc(List<InterfaceVo> tagSummaries, Long projectId, Long envId, int pattern, Long interfaceId) {
        StatusCode statusCode;
        switch (pattern) {
            //1. 同名覆盖
            case ImportInterfaceDoc.URL_OVERWRITE:
                statusCode = nameOverwrite(tagSummaries, projectId, envId, interfaceId);
                break;
            //2. 同名同组覆盖
            case ImportInterfaceDoc.URL_GROUPING_OVERWRITE:
                statusCode = nameGroupingOverwrite(tagSummaries, projectId, envId, interfaceId);
                break;
            //3. 同名不覆盖
            case ImportInterfaceDoc.NOT_URL_OVERWRITE:
                statusCode = notNameOverwrite(tagSummaries, projectId, envId, interfaceId);
                break;
            //4. 同名同组不覆盖
            case ImportInterfaceDoc.NOT_URL_GROUPING_OVERWRITE:
                statusCode = notNameGroupingOverwrite(tagSummaries, projectId, envId, interfaceId);
                break;
            //5. 同时存在
            case ImportInterfaceDoc.COEXIST:
                statusCode = coexist(tagSummaries, projectId, envId, interfaceId);
                break;
            default:
                throw new GlobalException("请选择正确的导入类型");
        }
        return statusCode;
    }

    /**
     * 1. 同url覆盖
     * <p>
     * //     * @param interfaceVos 接口文档Vo类
     *
     * @param projectId   项目id
     * @param envId       环境id
     * @param interfaceId 父级分组
     * @return 导入情况
     */
    private StatusCode nameOverwrite(List<InterfaceVo> interfaceVos, Long projectId, Long envId, Long interfaceId) {
        int saveNum = 0;
        int updateNum = 0;
        int ignoreNum = 0;
        StatusCode statusCode = new StatusCode();
        statusCode.setSwaggerDataType(SwaggerDataType.INTERFACE_DOC);
        if (!CollectionUtils.isEmpty(interfaceVos)) {
            //导入的接口       将当前导入的对象按照tag分组
            Map<String, List<InterfaceVo>> tagMap = interfaceVos.stream()
                    .filter(interfaceVo -> interfaceVo != null && interfaceVo.getTags() != null && !"".equals(interfaceVo.getTags()))
                    .collect(Collectors.groupingBy(InterfaceVo::getTags));
            //当前项目中所有的pathUrl(唯一的),同名的取第一个
            List<InterfaceDoc> interfaceDocList = getDocByPathUrl(projectId);
            if (!CollectionUtils.isEmpty(tagMap)) {
                Set<String> tags = tagMap.keySet();
                if (!CollectionUtils.isEmpty(tags)) {
                    //tag 当前分组
                    for (String tag : tags) {
                        //判断分组是否存在，如果不存在就创建，存在就直接用存在的分组id(多个取第一个)
                        Long groupingId = getInterfaceGroupingId(projectId, interfaceId, tag, envId);
                        //当前分组下的所有接口+tag
                        List<InterfaceVo> interfaceVoList = tagMap.get(tag);
                        for (InterfaceVo interfaceVo : interfaceVoList) {
                            //当前分组下的接口
                            InterfaceDoc interfaceDoc = interfaceVo.toInterfaceDoc();
//                            if (interfaceVo.getParameters().toJSONString() != null) {
//                                interfaceDoc.setParameters(interfaceVo.getParameters().toJSONString());
//                            }
//                            if (interfaceVo.getResponses().toJSONString() != null) {
//                                interfaceDoc.setResponses(interfaceVo.getResponses().toJSONString());
//                            }
                            interfaceDoc.setEnvId(envId);
                            interfaceDoc.setInterfaceGroupId(groupingId);
                            interfaceDoc.setProjectId(projectId);
                            //判断这条数据是否存在(当前项目,url)
                            List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                                    .eq(InterfaceDoc::getProjectId, projectId)
                                    .eq(InterfaceDoc::getPathUrl, interfaceDoc.getPathUrl()))).orElse(new ArrayList<>());
                            //不为null说明存在这条pathUrl
                            if (!CollectionUtils.isEmpty(interfaceDocs)) {
                                //获取到这条数据的主键id，为了后面可以将id放到新的数据中
                                Long id = interfaceDocs.get(0).getId();
                                interfaceDoc.setId(id);
                                //覆盖数据也就是更新
                                Integer integer = Optional.of(interfaceDocMapper.updateById(interfaceDoc)).orElseThrow(() -> new GlobalException("修改失败"));
                                //如果导入需要导入测试用例
                                updateNum = updateNum + integer;
                                //然后将查询到已经存在的数据删除掉，剩下的就是本次导入不存在，但是原始数据中存在的
                                interfaceDocList.remove(interfaceDoc);
                            } else {
                                //不存在的话直接新增
                                Integer integer = Optional.of(interfaceDocMapper.insert(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"));
                                saveNum = saveNum + integer;
                            }
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(interfaceDocList)) {
                for (InterfaceDoc interfaceDoc : interfaceDocList) {
                    interfaceDoc.setStatus(SyncStatus.OTHER);
                    interfaceDocMapper.updateById(interfaceDoc);
                }
            }
        }
        statusCode.setSaveNum(saveNum);
        statusCode.setUpdateNum(updateNum);
        statusCode.setIgnoreNum(ignoreNum);
        return statusCode;
    }

    /**
     * 2. 同url同分组覆盖
     *
     * @param projectId   项目id
     * @param envId       环境id
     * @param interfaceId 父级分组
     * @return 导入情况
     */
    private StatusCode nameGroupingOverwrite(List<InterfaceVo> interfaceVos, Long projectId, Long envId, Long interfaceId) {
        int saveNum = 0;
        int updateNum = 0;
        int ignoreNum = 0;
        StatusCode statusCode = new StatusCode();
        statusCode.setSwaggerDataType(SwaggerDataType.INTERFACE_DOC);
        if (!CollectionUtils.isEmpty(interfaceVos)) {
            //当前项目中存在的数据，同名同组的取第一个
            List<InterfaceDoc> docByPathUrlAndGrouping = getDocByPathUrlAndGrouping(projectId);
            //导入的数据根据tag分组
            Map<String, List<InterfaceVo>> tagsMap = interfaceVos.stream()
                    .filter(interfaceVo -> interfaceVo != null && interfaceVo.getTags() != null && !"".equals(interfaceVo.getTags()))
                    .collect(Collectors.groupingBy(InterfaceVo::getTags));
            if (!CollectionUtils.isEmpty(tagsMap)) {
                Set<String> tags = tagsMap.keySet();
                if (!CollectionUtils.isEmpty(tags)) {
                    for (String tag : tags) {
                        //判断分组是否存在，如果不存在就创建，存在就直接用存在的分组id(多个取第一个)
                        Long groupingId = getInterfaceGroupingId(projectId, interfaceId, tag, envId);
                        //当前分组中的所有接口(导入的数据)
                        List<InterfaceVo> interfaceVoList = tagsMap.get(tag);
                        for (InterfaceVo interfaceVo : interfaceVoList) {
                            //当前分组下的接口
                            InterfaceDoc interfaceDoc = interfaceVo.toInterfaceDoc();
//                            if (interfaceVo.getParameters().toJSONString() != null) {
//                                interfaceDoc.setParameters(interfaceVo.getParameters().toJSONString());
//                            }
//                            if (interfaceVo.getResponses().toJSONString() != null) {
//                                interfaceDoc.setResponses(interfaceVo.getResponses().toJSONString());
//                            }
                            interfaceDoc.setProjectId(projectId);
                            interfaceDoc.setEnvId(envId);
                            interfaceDoc.setInterfaceGroupId(groupingId);
                            //判断这条数据是否存在(当前项目,分组,url)
                            List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                                    .eq(InterfaceDoc::getProjectId, projectId)
                                    .eq(InterfaceDoc::getPathUrl, interfaceDoc.getPathUrl())
                                    .eq(InterfaceDoc::getInterfaceGroupId, interfaceDoc.getInterfaceGroupId()))).orElse(new ArrayList<>());
                            //不为null说明存在这条pathUrl
                            if (!CollectionUtils.isEmpty(interfaceDocs)) {
                                //获取到这条数据的主键id，为了后面可以将id放到新的数据中
                                Long id = interfaceDocs.get(0).getId();
                                interfaceDoc.setId(id);
                                //覆盖数据也就是更新
                                Integer integer = Optional.of(interfaceDocMapper.updateById(interfaceDoc)).orElseThrow(() -> new GlobalException("修改失败"));
                                updateNum = updateNum + integer;
                                //然后将查询到已经存在的数据删除掉，剩下的就是本次导入不存在，但是原始数据中存在的
                                docByPathUrlAndGrouping.remove(interfaceDoc);
                            } else {
                                //不存在的话直接新增
                                Integer integer = Optional.of(interfaceDocMapper.insert(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"));
                                saveNum = saveNum + integer;
                            }
                        }

                    }
                }
            }
            if (!CollectionUtils.isEmpty(docByPathUrlAndGrouping)) {
                for (InterfaceDoc interfaceDoc : docByPathUrlAndGrouping) {
                    interfaceDoc.setStatus(SyncStatus.OTHER);
                    interfaceDocMapper.updateById(interfaceDoc);
                }
            }
        }
        statusCode.setSaveNum(saveNum);
        statusCode.setUpdateNum(updateNum);
        statusCode.setIgnoreNum(ignoreNum);
        return statusCode;
    }

    /**
     * 3. 同url不覆盖
     *
     * @param projectId   项目id
     * @param envId       环境id
     * @param interfaceId 父级分组
     * @return 导入情况
     */
    private StatusCode notNameOverwrite(List<InterfaceVo> interfaceVos, Long projectId, Long envId, Long interfaceId) {
        int saveNum = 0;
        int updateNum = 0;
        int ignoreNum = 0;
        StatusCode statusCode = new StatusCode();
        statusCode.setSwaggerDataType(SwaggerDataType.INTERFACE_DOC);
        if (!CollectionUtils.isEmpty(interfaceVos)) {
            //当前项目中所有的pathUrl(唯一的)
            List<InterfaceDoc> interfaceDocList = getDocByPathUrl(projectId);
            //导入的接口       将当前导入的对象按照tag分组
            Map<String, List<InterfaceVo>> tagMap = interfaceVos.stream()
                    .filter(interfaceVo -> interfaceVo != null && interfaceVo.getTags() != null && !"".equals(interfaceVo.getTags()))
                    .collect(Collectors.groupingBy(InterfaceVo::getTags));
            if (!CollectionUtils.isEmpty(tagMap)) {
                Set<String> tags = tagMap.keySet();
                if (!CollectionUtils.isEmpty(tags)) {
                    //tag 当前分组
                    for (String tag : tags) {
                        //判断分组是否存在，如果不存在就创建，存在就直接用存在的分组id(多个取第一个)
                        Long groupingId = getInterfaceGroupingId(projectId, interfaceId, tag, envId);
                        //当前分组下的所有接口+tag
                        List<InterfaceVo> interfaceVoList = tagMap.get(tag);
                        for (InterfaceVo interfaceVo : interfaceVoList) {
                            //当前分组下的接口
                            InterfaceDoc interfaceDoc = interfaceVo.toInterfaceDoc();
                            interfaceDoc.setProjectId(projectId);
                            //判断这条数据是否存在(当前项目,url)
                            List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                                    .eq(InterfaceDoc::getProjectId, projectId)
                                    .eq(InterfaceDoc::getPathUrl, interfaceDoc.getPathUrl()))).orElse(new ArrayList<>());
                            //不为null说明存在这条pathUrl
                            if (!CollectionUtils.isEmpty(interfaceDocs)) {
                                //不做任何操作，忽略数量+1
                                ignoreNum = ignoreNum + 1;
                                //然后将查询到已经存在的数据删除掉，剩下的就是本次导入不存在，但是原始数据中存在的
                                interfaceDocList.remove(interfaceDoc);
                            } else {
                                interfaceDoc.setEnvId(envId);
                                interfaceDoc.setInterfaceGroupId(groupingId);
//                                if (interfaceVo.getParameters().toJSONString() != null) {
//                                    interfaceDoc.setParameters(interfaceVo.getParameters().toJSONString());
//                                }
//                                if (interfaceVo.getResponses().toJSONString() != null) {
//                                    interfaceDoc.setResponses(interfaceVo.getResponses().toJSONString());
//                                }
                                //不存在的话直接新增
                                Integer integer = Optional.of(interfaceDocMapper.insert(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"));
                                saveNum = saveNum + integer;
                            }
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(interfaceDocList)) {
                for (InterfaceDoc interfaceDoc : interfaceDocList) {
                    interfaceDoc.setStatus(SyncStatus.OTHER);
                    interfaceDocMapper.updateById(interfaceDoc);
                }
            }
        }
        statusCode.setSaveNum(saveNum);
        statusCode.setUpdateNum(updateNum);
        statusCode.setIgnoreNum(ignoreNum);
        return statusCode;
    }

    /**
     * 4. 同url同分组不覆盖
     *
     * @param projectId   项目id
     * @param envId       环境id
     * @param interfaceId 父级分组
     * @return 导入情况
     */
    private StatusCode notNameGroupingOverwrite(List<InterfaceVo> interfaceVos, Long projectId, Long envId, Long interfaceId) {
        int saveNum = 0;
        int updateNum = 0;
        int ignoreNum = 0;
        StatusCode statusCode = new StatusCode();
        statusCode.setSwaggerDataType(SwaggerDataType.INTERFACE_DOC);
        if (!CollectionUtils.isEmpty(interfaceVos)) {
            //导入的数据根据tag分组
            Map<String, List<InterfaceVo>> tagsMap = interfaceVos.stream()
                    .filter(interfaceVo -> interfaceVo != null && interfaceVo.getTags() != null && !"".equals(interfaceVo.getTags()))
                    .collect(Collectors.groupingBy(InterfaceVo::getTags));
            //当前项目中存在的数据，同名同组的取第一个
            List<InterfaceDoc> docByPathUrlAndGrouping = getDocByPathUrlAndGrouping(projectId);
            if (!CollectionUtils.isEmpty(tagsMap)) {
                Set<String> tags = tagsMap.keySet();
                if (!CollectionUtils.isEmpty(tags)) {
                    for (String tag : tags) {
                        //判断分组是否存在，如果不存在就创建，存在就直接用存在的分组id(多个取第一个)
                        Long groupingId = getInterfaceGroupingId(projectId, interfaceId, tag, envId);
                        //当前分组中的所有接口(导入的数据)
                        List<InterfaceVo> interfaceVoList = tagsMap.get(tag);
                        for (InterfaceVo interfaceVo : interfaceVoList) {
                            //当前分组下的接口
                            InterfaceDoc interfaceDoc = interfaceVo.toInterfaceDoc();
                            interfaceDoc.setEnvId(envId);
                            interfaceDoc.setInterfaceGroupId(groupingId);
                            interfaceDoc.setProjectId(projectId);
//                            if (interfaceVo.getParameters().toJSONString() != null) {
//                                interfaceDoc.setParameters(interfaceVo.getParameters().toJSONString());
//                            }
//                            if (interfaceVo.getResponses().toJSONString() != null) {
//                                interfaceDoc.setResponses(interfaceVo.getResponses().toJSONString());
//                            }
                            //判断这条数据是否存在(当前项目,分组,url)
                            List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                                    .eq(InterfaceDoc::getProjectId, projectId)
                                    .eq(InterfaceDoc::getPathUrl, interfaceDoc.getPathUrl())
                                    .eq(InterfaceDoc::getInterfaceGroupId, interfaceDoc.getInterfaceGroupId()))).orElse(new ArrayList<>());
                            //不为null说明存在这条pathUrl
                            if (!CollectionUtils.isEmpty(interfaceDocs)) {
                                //不做任何操作，忽略数量+1
                                ignoreNum = ignoreNum + 1;
                                //然后将查询到已经存在的数据删除掉，剩下的就是本次导入不存在，但是原始数据中存在的
                                docByPathUrlAndGrouping.remove(interfaceDoc);
                            } else {
                                //不存在的话直接新增
                                Integer integer = Optional.of(interfaceDocMapper.insert(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"));
                                saveNum = saveNum + integer;
                            }
                        }

                    }
                }
            }
            if (!CollectionUtils.isEmpty(docByPathUrlAndGrouping)) {
                for (InterfaceDoc interfaceDoc : docByPathUrlAndGrouping) {
                    interfaceDoc.setStatus(SyncStatus.OTHER);
                    interfaceDocMapper.updateById(interfaceDoc);
                }
            }
        }
        statusCode.setSaveNum(saveNum);
        statusCode.setUpdateNum(updateNum);
        statusCode.setIgnoreNum(ignoreNum);
        return statusCode;
    }

    /**
     * 5. 同时存在
     *
     * @param projectId   项目id
     * @param envId       环境id
     * @param interfaceId 父级分组
     * @return 导入情况
     */
    private StatusCode coexist(List<InterfaceVo> interfaceVos, Long projectId, Long envId, Long interfaceId) {
        int saveNum = 0;
        int updateNum = 0;
        int ignoreNum = 0;
        StatusCode statusCode = new StatusCode();
        statusCode.setSwaggerDataType(SwaggerDataType.INTERFACE_DOC);
        if (interfaceVos.size() != 0) {
            //当前项目中所有的接口文档
            List<InterfaceDoc> interfaceDocList = Optional.of(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                    .eq(InterfaceDoc::getProjectId, projectId))).orElse(new ArrayList<>());
            //取出key : url value : 接口文档对象
            Map<String, List<InterfaceDoc>> urlsMap = interfaceDocList.stream()
                    .filter(interfaceDoc -> interfaceDoc != null && interfaceDoc.getPathUrl() != null && !"".equals(interfaceDoc.getPathUrl()))
                    .collect(Collectors.groupingBy(InterfaceDoc::getPathUrl));
            //存在的不同Url的接口
            List<InterfaceDoc> list = new ArrayList<>();
            if (!CollectionUtils.isEmpty(urlsMap)) {
                Set<String> pathUrls = urlsMap.keySet();
                if (!CollectionUtils.isEmpty(pathUrls)) {
                    for (String pathUrl : pathUrls) {
                        InterfaceDoc interfaceDoc = urlsMap.get(pathUrl).get(0);
                        list.add(interfaceDoc);
                    }
                }
            }
            //导入的数据
            Map<String, List<InterfaceVo>> tagsMap = interfaceVos.stream()
                    .filter(interfaceVo -> interfaceVo != null && interfaceVo.getTags() != null && !"".equals(interfaceVo.getTags()))
                    .collect(Collectors.groupingBy(InterfaceVo::getTags));
            if (!CollectionUtils.isEmpty(tagsMap)) {
                Set<String> tags = tagsMap.keySet();
                if (!CollectionUtils.isEmpty(tags)) {
                    for (String tag : tags) {
                        Long groupingId = getInterfaceGroupingId(projectId, interfaceId, tag, envId);
                        //tag分组下的所有接口
                        List<InterfaceVo> interfaceVoList = tagsMap.get(tag);
                        for (InterfaceVo interfaceVo : interfaceVoList) {
                            InterfaceDoc interfaceDoc = interfaceVo.toInterfaceDoc();
                            interfaceDoc.setInterfaceGroupId(groupingId);
                            interfaceDoc.setProjectId(projectId);
                            interfaceDoc.setStatus(SyncStatus.COPY);
//                            if (interfaceVo.getParameters().toJSONString() != null) {
//                                interfaceDoc.setParameters(interfaceVo.getParameters().toJSONString());
//                            }
//                            interfaceDoc.setEnvId(envId);
//                            if (interfaceVo.getResponses().toJSONString() != null) {
//                                interfaceDoc.setResponses(interfaceVo.getResponses().toJSONString());
//                            }
                            //todo 负责人，以及开发状态未添加
                            Integer integer = Optional.of(interfaceDocMapper.insert(interfaceDoc)).orElseThrow(() -> new GlobalException("添加失败"));
                            saveNum = saveNum + integer;
                            //操作数据库中存在的接口
                            for (InterfaceDoc doc : list) {
                                //如果url相同就设置成未同步
                                if (doc.getPathUrl().equals(interfaceDoc.getPathUrl())) {
                                    list.remove(doc);
                                    doc.setStatus(SyncStatus.NO);
                                    interfaceDocMapper.updateById(doc);
                                    break;
                                }
                            }
                        }
                        //剩下的就是当前存在，但是导入的数据中不存在的
                        if (list.size() != 0) {
                            for (InterfaceDoc interfaceDoc : list) {
                                interfaceDoc.setStatus(SyncStatus.OTHER);
                                interfaceDocMapper.updateById(interfaceDoc);
                            }
                        }
                    }
                }
            }
        }
        statusCode.setSaveNum(saveNum);
        statusCode.setUpdateNum(updateNum);
        statusCode.setIgnoreNum(ignoreNum);
        return statusCode;
    }

    /**
     * 获取分组id
     *
     * @param projectId           项目id
     * @param interfaceGroupingId 分组
     * @param tag                 分组名称
     * @return 分组的主键id
     */
    private Long getInterfaceGroupingId(Long projectId, Long interfaceGroupingId, String tag, Long envId) {
        Long id;
        //查询分组是否存在
        List<InterfaceGrouping> interfaceGroupings = Optional.of(interfaceGroupingMapper.selectList(Wrappers.lambdaQuery(InterfaceGrouping.class)
                .eq(InterfaceGrouping::getProjectId, projectId)
                .eq(InterfaceGrouping::getInterfaceGroupingId, interfaceGroupingId)
                .eq(InterfaceGrouping::getTag, tag))).orElse(new ArrayList<>());
        if (interfaceGroupings.size() != 0) {
            InterfaceGrouping interfaceGrouping = interfaceGroupings.get(0);
            interfaceGrouping.setEnvId(envId);
            interfaceGroupingMapper.updateById(interfaceGrouping);
            id = interfaceGrouping.getId();
        } else {
            //添加接口分组
            InterfaceGrouping interfaceGrouping = new InterfaceGrouping();
            interfaceGrouping.setInterfaceGroupingId(interfaceGroupingId);
            interfaceGrouping.setProjectId(projectId);
            interfaceGrouping.setTag(tag);
            interfaceGrouping.setEnvId(envId);
            interfaceGroupingMapper.insert(interfaceGrouping);
            id = interfaceGroupingMapper.selectList(Wrappers.lambdaQuery(InterfaceGrouping.class)
                    .eq(InterfaceGrouping::getProjectId, projectId)
                    .eq(InterfaceGrouping::getInterfaceGroupingId, interfaceGroupingId)
                    .eq(InterfaceGrouping::getTag, tag)).get(0).getId();
        }
        return id;
    }

    /**
     * 当前项目中的根据pathUrl去重，取第一个
     *
     * @param projectId 项目id
     * @return 唯一pathUrl的接口集合
     */
    public List<InterfaceDoc> getDocByPathUrl(Long projectId) {
        List<InterfaceDoc> list = new ArrayList<>();
        //当前项目中的所有接口
        List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                .eq(InterfaceDoc::getProjectId, projectId))).orElse(new ArrayList<>());
        //根据pathUrl取出独一份pathUrl的接口
        if (!CollectionUtils.isEmpty(interfaceDocs)) {
            Map<String, List<InterfaceDoc>> pathUrlMap = interfaceDocs.stream()
                    .filter(interfaceDoc -> interfaceDoc != null && interfaceDoc.getPathUrl() != null && !"".equals(interfaceDoc.getPathUrl()))
                    .collect(Collectors.groupingBy(InterfaceDoc::getPathUrl));
            if (!CollectionUtils.isEmpty(pathUrlMap)) {
                Set<String> pathUrls = pathUrlMap.keySet();
                if (!CollectionUtils.isEmpty(pathUrls)) {
                    for (String pathUrl : pathUrls) {
                        InterfaceDoc interfaceDoc = pathUrlMap.get(pathUrl).get(0);
                        list.add(interfaceDoc);
                    }
                }
            }
        }
        return list;
    }

    /**
     * 当前项目中同url同分组的数据
     *
     * @param projectId 项目id
     * @return 唯一pathUrl的接口集合
     */
    public List<InterfaceDoc> getDocByPathUrlAndGrouping(Long projectId) {
        List<InterfaceDoc> list = new ArrayList<>();
        //项目中存在的数据
        List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                .eq(InterfaceDoc::getProjectId, projectId))).orElse(new ArrayList<>());
        //找到分组以及pathUrl都相同的数据
        if (!CollectionUtils.isEmpty(interfaceDocs)) {
            Map<String, List<InterfaceDoc>> pathUrlMap = interfaceDocs.stream()
                    .filter(interfaceDoc -> interfaceDoc != null && interfaceDoc.getPathUrl() != null && !"".equals(interfaceDoc.getPathUrl()))
                    .collect(Collectors.groupingBy(InterfaceDoc::getPathUrl));
            if (!CollectionUtils.isEmpty(pathUrlMap)) {
                Set<String> pathUrls = pathUrlMap.keySet();
                if (!CollectionUtils.isEmpty(pathUrls)) {
                    for (String pathUrl : pathUrls) {
                        List<InterfaceDoc> interfaceDocList = pathUrlMap.get(pathUrl);
                        //url 与 分组 都相同的
                        Map<Long, List<InterfaceDoc>> groupingMap = interfaceDocList.stream()
                                .filter(interfaceDoc -> interfaceDoc != null && interfaceDoc.getInterfaceGroupId() != null)
                                .collect(Collectors.groupingBy(InterfaceDoc::getInterfaceGroupId));
                        if (!CollectionUtils.isEmpty(groupingMap)) {
                            Set<Long> longs = groupingMap.keySet();
                            if (!CollectionUtils.isEmpty(longs)) {
                                for (Long aLong : longs) {
                                    List<InterfaceDoc> urlGroupings = groupingMap.get(aLong);
                                    //只取第一条
                                    if (!CollectionUtils.isEmpty(urlGroupings)) {
                                        list.add(urlGroupings.get(0));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return list;
    }
}