package org.matrix.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.entity.InterfaceDoc;
import org.matrix.entity.InterfaceGrouping;
import org.matrix.mapper.InterfaceDocMapper;
import org.matrix.mapper.InterfaceGroupingMapper;
import org.matrix.service.IInterfaceGroupingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author mruny
 * @create 2022/7/18 11:29:05
 */
@Service
public class InterfaceGroupingServiceImpl extends ServiceImpl<InterfaceGroupingMapper, InterfaceGrouping> implements IInterfaceGroupingService {

    @Autowired
    private InterfaceGroupingMapper interfaceGroupingMapper;

    @Autowired
    private InterfaceDocMapper interfaceDocMapper;

    @Override
    public void removeInterfaceGrouping(Long id) {
        //删除当前分组下的接口文档
        List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                .eq(InterfaceDoc::getInterfaceGroupId, id))).orElse(new ArrayList<>());
        if (interfaceDocs.size() != 0) {
            interfaceDocMapper.deleteBatchIds(interfaceDocs);
        }
        recursionInterface(id);
        //最后删除当前分组
        interfaceGroupingMapper.deleteById(id);
    }

    /**
     * 递归处理当前分组下的分组
     *
     * @param id 当前分组id
     */
    public void recursionInterface(Long id) {
        //找到当前分组下的子分组
        List<InterfaceGrouping> interfaceGroupings = Optional.ofNullable(interfaceGroupingMapper.selectList(Wrappers.lambdaQuery(InterfaceGrouping.class)
                .eq(InterfaceGrouping::getInterfaceGroupingId, id))).orElse(new ArrayList<>());
        //是否存在子分组，如果不存在就不做任何操作，如果存在进入下一层
        if (interfaceGroupings.size() != 0) {
            //找到当前分组下的每个子类分组
            for (InterfaceGrouping interfaceGrouping : interfaceGroupings) {
                //删除子类分组中的数据模型
                Long groupingId = interfaceGrouping.getId();
                List<InterfaceGrouping> recursionsInterfaces = Optional.ofNullable(interfaceGroupingMapper.selectList(Wrappers.lambdaQuery(InterfaceGrouping.class)
                        .eq(InterfaceGrouping::getInterfaceGroupingId, groupingId))).orElse(new ArrayList<>());
                if (recursionsInterfaces.size() != 0) {
                    interfaceDocMapper.deleteBatchIds(recursionsInterfaces);
                }
                recursionInterface(groupingId);
                //删除当前分组下的接口
                List<InterfaceDoc> interfaceDocs = Optional.ofNullable(interfaceDocMapper.selectList(Wrappers.lambdaQuery(InterfaceDoc.class)
                        .eq(InterfaceDoc::getInterfaceGroupId, groupingId))).orElse(new ArrayList<>());
                if (interfaceDocs.size() != 0) {
                    interfaceDocMapper.deleteBatchIds(interfaceDocs);
                }
            }
        }
    }

}
