package org.matrix.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.entity.MouldDoc;
import org.matrix.entity.MouldGrouping;
import org.matrix.mapper.MouldDocMapper;
import org.matrix.mapper.MouldGroupingMapper;
import org.matrix.service.IMouldGroupingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author mruny
 * @create 2022/7/18 11:29:29
 */
@Service
public class MouldGroupingServiceImpl extends ServiceImpl<MouldGroupingMapper, MouldGrouping> implements IMouldGroupingService {

    @Autowired
    private MouldGroupingMapper mouldGroupingMapper;

    @Autowired
    private MouldDocMapper mouldDocMapper;

    @Override
    public void removeMould(Long id) {
        //删除当前分组下的数据模型
        List<MouldDoc> mouldDocs = Optional.ofNullable(mouldDocMapper.selectList(Wrappers.lambdaQuery(MouldDoc.class)
                .eq(MouldDoc::getMouldGroupingId, id))).orElse(new ArrayList<>());
        if (mouldDocs.size() != 0) {
            mouldDocMapper.deleteBatchIds(mouldDocs);
        }
        recursionMould(id);
        //最后删除当前分组
        mouldGroupingMapper.deleteById(id);
    }

    /**
     * 递归处理当前分组下的分组
     *
     * @param id 当前分组id
     */
    public void recursionMould(Long id) {
        //找到当前分组下的子分组
        List<MouldGrouping> mouldGroupings = Optional.ofNullable(mouldGroupingMapper.selectList(Wrappers.lambdaQuery(MouldGrouping.class)
                .eq(MouldGrouping::getMouldId, id))).orElse(new ArrayList<>());
        //是否存在子分组，如果不存在就不做任何操作，如果存在进入下一层
        if (mouldGroupings.size() != 0) {
            //找到当前分组下的每个子类分组
            for (MouldGrouping mouldGrouping : mouldGroupings) {
                //删除子类分组中的数据模型
                Long groupingId = mouldGrouping.getId();
                List<MouldGrouping> recursionsMoulds = Optional.ofNullable(mouldGroupingMapper.selectList(Wrappers.lambdaQuery(MouldGrouping.class)
                        .eq(MouldGrouping::getMouldId, groupingId))).orElse(new ArrayList<>());
                if (recursionsMoulds.size() != 0) {
                    mouldDocMapper.deleteBatchIds(recursionsMoulds);
                }
                recursionMould(groupingId);
                //删除当前分组下的接口
                List<MouldDoc> mouldDocs = Optional.ofNullable(mouldDocMapper.selectList(Wrappers.lambdaQuery(MouldDoc.class)
                        .eq(MouldDoc::getMouldGroupingId, groupingId))).orElse(new ArrayList<>());
                if (mouldDocs.size() != 0) {
                    mouldDocMapper.deleteBatchIds(mouldDocs);
                }
            }
        }
    }

}
