package org.matrix.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.enums.ExecutionHistoryStatus;
import org.matrix.enums.ExecutionType;

import java.time.LocalDateTime;

/**
 * ExecutionHisVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/16 at 4:16 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ExecutionHisVo {

    /**
     * 调试/执行的类型 - 1 = 接口case 2 = 测试任务job
     */
    private ExecutionType type;

    /**
     * 主键id type 1 = case(接口)主键id , 2 = job(测试任务)主键id
     */
    private Long id;

    /**
     * uniqueKey 独立key
     */
    private String uniqueKey;

    /**
     * 调试/执行的顺序号
     */
    private Long executionOrder;

    /**
     * 调试/执行的开始时间
     */
    private LocalDateTime startTime;

    /**
     * 调试/执行 锁消耗的时间
     */
    private Long costMills;

    /**
     * 状态
     */
    private ExecutionHistoryStatus status;


}
