package org.matrix.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.enums.SyncStatus;

import java.util.List;

/**
 * @author mruny
 * @create 2022/8/3 15:31:12
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("接口文档Vo")
public class InterfaceDocVo {

    @ApiModelProperty("接口文档下可以存在多个测试用例")
    private List<TestCaseVo> testCaseVos;

    /**
     * id
     */
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 名称
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称")
    private String summary;

    /**
     * 说明
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("说明")
    private String des;

    /**
     * 请求方式
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("请求方式")
    private String httpMethod;

    /**
     * 接口相对路径
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("接口相对路径")
    private String pathUrl;

    /**
     * 参数详情(整段json)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("参数详情(整段json)")
    private String parameters;

    /**
     * 返回值信息(整段json)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("返回值信息(整段json)")
    private String responses;

    /**
     * 项目id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 环境id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("环境id")
    private Long envId;

    /**
     * 分组id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("分组id")
    private Long interfaceGroupId;

    /**
     * 同步状态
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("同步状态")
    private SyncStatus status;

    /**
     * 开发状态
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("开发状态")
    private String devStatus;

    /**
     * 负责人
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("负责人")
    private String dutyPeople;
}
