package org.matrix.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author mruny
 * @create 2022/8/3 15:19:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("项目中的所有接口分组,接口,测试用例")
public class InterfaceGroupVo {

    /**
     * 分组下可以存在多个分组
     */
    @ApiModelProperty("分组下可以存在多个分组")
    private List<InterfaceGroupVo> interfaceGroupVos;

    /**
     * 分组下可以存在多个接口
     */
    @ApiModelProperty("分组下可以存在多个接口")
    private List<InterfaceDocVo> interfaceDocVos;

    /**
     * id
     */
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 名称（标签/分组(存在根目录)）
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称（标签/分组(存在根目录)）")
    private String tag;

    /**
     * 说明
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("说明")
    private String des;

    /**
     * 环境id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("环境id")
    private Long envId;

    /**
     * 项目id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 前置操作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("前置操作id")
    private Long moveBefore;

    /**
     * 后置操作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("后置操作id")
    private Long moveAfter;

    /**
     * 父类id(根目录默认为0)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("父类id(根目录默认为0)")
    private Long interfaceGroupingId;
}
