package org.matrix.vo;

import com.alibaba.fastjson.JSONArray;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.entity.InterfaceDoc;
import org.matrix.enums.SyncStatus;
import org.springframework.beans.BeanUtils;

/**
 * @author mruny
 * @create 2022/7/18 15:53:34
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InterfaceVo {

    /**
     * 名称
     */
    private String summary;

    /**
     * 说明
     */
    private String des;

    /**
     * 请求方式
     */
    private String httpMethod;

    /**
     * 接口相对路径
     */
    private String pathUrl;

    /**
     * 参数详情(整段json)
     */
    private JSONArray parameters;

    /**
     * 返回值信息(整段json)
     */
    private JSONArray responses;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 环境id
     */
    private Long envId;

    /**
     * 分组id
     */
    private Long interfaceGroupId;

    /**
     * 同步状态
     */
    private SyncStatus status;

    /**
     * 开发状态
     */
    private String devStatus;

    /**
     * 负责人
     */
    private String dutyPeople;

    private String tags;

    public InterfaceDoc toInterfaceDoc() {
        InterfaceDoc interfaceDoc = new InterfaceDoc();
        BeanUtils.copyProperties(this, interfaceDoc);
        return interfaceDoc;
    }
}
