package org.matrix.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author mruny
 * @create 2022/8/3 15:40:01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("测试用例Vo类")
public class TestCaseVo {

    /**
     * id
     */
    @ApiModelProperty("主键id")
    private Long id;

    /**
     * 名称
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("名称")
    private String name;

    /**
     * 接口文档id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("接口文档id")
    private Long docId;

    /**
     * 请求方式
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("请求方式")
    private String httpMethod;

    /**
     * 参数详情(包括参数值)
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("参数详情(包括参数值)")
    private String parameters;

    /**
     * 前置动作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("前置动作id")
    private Long moveBefore;

    /**
     * 后置动作id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("后置动作id")
    private Long moveAfter;

    /**
     * 项目id
     */
    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty("项目id")
    private Long projectId;

}
