package org.matrix.vo.swaggerEntityVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 内部属性，对象的字段的属性包括 : 类型，描述等
 *
 * @author mruny
 * @create 2022/7/8 15:20:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("AttributeInVo内部属性，对象的字段的属性包括 : 类型，描述等")
public class AttributeInVo {

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("格式")
    private String format;

    @ApiModelProperty("枚举")
    private List<String> enumType;

    @ApiModelProperty("map类型出现的情况")
    private String additionalProperties;

    @ApiModelProperty("实例")
    private List<String> example;

    @ApiModelProperty("$ref")
    private String ref;

    @ApiModelProperty("子类")
    private AttributeInVo items;
}
