package org.matrix.vo.swaggerEntityVo.definitionsEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.vo.swaggerEntityVo.AttributeInVo;

import java.util.List;

/**
 * 外部属性，对象中的属性，以及对象中属性的类型描述等
 *
 * @author mruny
 * @create 2022/7/8 14:34:05
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("AttributeOutVo外部属性，对象中的属性，以及对象中属性的类型描述等")
public class AttributeOutVo {

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("对象名称")
    private String title;

    @ApiModelProperty("具体的参数详情")
    private List<PropertiesVo> propertiesVoList;

    @ApiModelProperty("map")
    private AttributeInVo additionalProperties;

}
