package org.matrix.vo.swaggerEntityVo.swaggerEntity;

import com.alibaba.fastjson.JSONArray;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.vo.swaggerEntityVo.responsesEntity.ResponseVo;

import java.util.List;

/**
 * @author MRY
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("PathVo接口信息")
public class PathVo {

    @ApiModelProperty("id")
    private Long identifierId;

    @ApiModelProperty("tagId")
    private Long tagId;

    @ApiModelProperty("url地址")
    private String pathUrl;

    @ApiModelProperty("请求方式")
    private String httpMethod;

    @ApiModelProperty("方法名，总结")
    private String summary;

    @ApiModelProperty("类名，标签")
    private String tags;

    @ApiModelProperty("入参")
    private JSONArray parameters;

    @ApiModelProperty("返回值")
    private List<ResponseVo> responses;

    @ApiModelProperty("operationId")
    private String operationId;

    @ApiModelProperty("deprecated")
    private String deprecated;

    @ApiModelProperty("consumes")
    private JSONArray consumes;

    @ApiModelProperty("produces")
    private JSONArray produces;

    @ApiModelProperty("security")
    private JSONArray security;

}
