package org.matrix.vo.swaggerEntityVo.swaggerEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.matrix.vo.swaggerEntityVo.definitionsEntity.DefinitionsVo;

import java.util.List;

/**
 * @author mruny
 * @create 2022/7/4 17:05:15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("swagger外层解析")
public class SwaggerOuter {

    @ApiModelProperty("host")
    private String host;

    @ApiModelProperty("/")
    private String basePath;

    @ApiModelProperty("参数")
    private List<DefinitionsVo> definitions;

    @ApiModelProperty("一级标签和二级标签集合")
    private List<TagSummary> tagSummaryList;
}
