package org.matrix.log.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

/**
 * @author C
 * 日志实体类
 * 使用MongoDB存储
 */
@Accessors(chain = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "Log对象", description = "日志")
@Document
public class Log {

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "所属项目id", position = 1)
    private Long projectId;

    @ApiModelProperty(value = "所属用户id", position = 2)
    private Long userId;

    @ApiModelProperty(value = "所属数据id", position = 3)
    private Long dataId;

    @ApiModelProperty(value = "所属数据类型 等同于其java类型", position = 4)
    private String dataType;

    @ApiModelProperty(value = "唯一标识id", position = 5)
    private Long uniqueId;

    @ApiModelProperty(value = "时间", position = 6)
    private Date time;

    @ApiModelProperty(value = "日志内容", position = 7)
    private List<String> contents;

}
