package org.matrix.log;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.junit.jupiter.api.Test;
import org.matrix.local.entity.User;
import org.matrix.local.mapper.UserMapper;
import org.matrix.local.service.impl.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;


@SpringBootTest
class LogApplicationTests {

    @Autowired
    UserService userService;

    @Test
    void contextLoads() {
        userService.create(new User().setAccount("test").setName("test").setPassword("test"));
    }

    public static void main(String[] args) {
        Type[] genericInterfaces = UserMapper.class
                .getGenericInterfaces();
        //取第1个为例
        ParameterizedType genericParameterType = (ParameterizedType) genericInterfaces[0];
        //获取到泛型(数组)
        Type[] actualTypeArguments = genericParameterType.getActualTypeArguments();
        System.out.println(actualTypeArguments[0].getClass().getName());
        System.out.println(actualTypeArguments[0].getTypeName());
    }
}
