package org.matrix.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * IdGenerator. 雪花算法的id生成器
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/5/26 at 5:40 PM
 * Suffering is the most powerful teacher of life.
 */
@Slf4j
@Component
public class IdGenerator {

    /**
     * 集群码
     */
    private long workerId = 0;

    /**
     * 机器码
     */
    private final long datacenterId = 1;

    private final Snowflake snowflake = IdUtil.createSnowflake(workerId, datacenterId);

    @PostConstruct
    public void init() {
        try {
            workerId = NetUtil.ipv4ToLong(NetUtil.getLocalhostStr());
            log.info("当前机器的IP： {}, workerId: {}", NetUtil.getLocalhostStr(), workerId);
        } catch (Exception e) {
            log.error("获取当前机器workerId 异常", e);
            workerId = NetUtil.getLocalhostStr().hashCode();
        }
    }

    /**
     * 使用默认的workId 和 datacenter
     *
     */
    public synchronized long nextId() {
        return snowflake.nextId();
    }

    /**
     * 使用自定义的workerId 和 datacenter
     *
     * @param workerId workerId
     * @param datacenterId datacenter
     */
    public synchronized long snowflakeId(long workerId, long datacenterId) {
        return IdUtil.createSnowflake(workerId, datacenterId).nextId();
    }
}
