package org.matrix.local.config.aop;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.matrix.local.entity.vo.UserInfo;
import org.matrix.local.enums.Authority;
import org.matrix.local.enums.Role;
import org.matrix.local.service.impl.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.util.Objects;
import java.util.Optional;

@Slf4j
@Aspect
@Component
public class AuthorityAOP {

    @Autowired
    private UserService userService;

    @Before("@annotation(org.matrix.local.config.aop.Authorize)")
    public void authorize(JoinPoint joinPoint) {
        Authorize authorize = ((MethodSignature) joinPoint.getSignature()).getMethod().getAnnotation(Authorize.class);
        Authority value = authorize.value();
        UserInfo userInfo = userService.findNow();
        Boolean isAdmin = userService.isAdmin(userInfo);
        if (!isAdmin) {
            if (Authority.ADMIN.equals(value)) {
                throw new RuntimeException("当前用户不具备相应权限");
            } else {
                Long projectId = Long.valueOf(Optional.of((ServletRequestAttributes) RequestContextHolder.currentRequestAttributes())
                        .map(ServletRequestAttributes::getRequest)
                        .map(request -> request.getParameter("projectId"))
                        .orElseThrow(() -> new RuntimeException("请在请求参数中附带projectId")));
                String role = userService.findRole(userInfo.getId(), projectId);
                boolean match = Role.getAuthorities(role).stream().anyMatch(authority -> Objects.equals(authority, value));
                if (!match) {
                    throw new RuntimeException("当前用户不具备相应权限");
                }
            }
        }
    }

}
